/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.WindowingExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeadLag;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.ql.udf.ptf.WindowingTableFunction;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class PTFDeserializer {
    PTFDesc ptfDesc;
    StructObjectInspector inputOI;
    HiveConf hConf;
    PTFTranslator.LeadLagInfo llInfo;

    public PTFDeserializer(PTFDesc ptfDesc, StructObjectInspector inputOI, HiveConf hConf) {
        this.ptfDesc = ptfDesc;
        ptfDesc.setCfg(hConf);
        this.inputOI = inputOI;
        this.hConf = hConf;
        this.llInfo = new PTFTranslator.LeadLagInfo();
        ptfDesc.setLlInfo(this.llInfo);
    }

    public void initializePTFChain(PTFDesc.PartitionedTableFunctionDef tblFnDef) throws HiveException {
        PTFDesc.PTFInputDef currentDef;
        Stack<PTFDesc.PartitionedTableFunctionDef> ptfChain = new Stack<PTFDesc.PartitionedTableFunctionDef>();
        for (currentDef = tblFnDef; currentDef != null; currentDef = ((PTFDesc.PTFInputDef)currentDef).getInput()) {
            ptfChain.push((PTFDesc.PartitionedTableFunctionDef)currentDef);
        }
        while (!ptfChain.isEmpty()) {
            currentDef = (PTFDesc.PTFInputDef)ptfChain.pop();
            if (currentDef instanceof PTFDesc.PTFQueryInputDef) {
                this.initialize((PTFDesc.PTFQueryInputDef)currentDef, this.inputOI);
                continue;
            }
            if (currentDef instanceof PTFDesc.WindowTableFunctionDef) {
                this.initializeWindowing((PTFDesc.WindowTableFunctionDef)currentDef);
                continue;
            }
            this.initialize((PTFDesc.PartitionedTableFunctionDef)currentDef);
        }
    }

    public void initializeWindowing(PTFDesc.WindowTableFunctionDef def) throws HiveException {
        PTFDesc.ShapeDetails inpShape = def.getInput().getOutputShape();
        TableFunctionEvaluator tEval = def.getTFunction();
        WindowingTableFunction.WindowingTableFunctionResolver tResolver = (WindowingTableFunction.WindowingTableFunctionResolver)this.constructResolver(def.getResolverClassName());
        tResolver.initialize(this.ptfDesc, def, tEval);
        for (PTFDesc.WindowFunctionDef wFnDef : def.getWindowFunctions()) {
            if (wFnDef.getArgs() != null) {
                for (PTFDesc.PTFExpressionDef arg : wFnDef.getArgs()) {
                    this.initialize(arg, inpShape);
                }
            }
            if (wFnDef.getWindowFrame() != null) {
                PTFDesc.WindowFrameDef wFrmDef = wFnDef.getWindowFrame();
                this.initialize(wFrmDef.getStart(), inpShape);
                this.initialize(wFrmDef.getEnd(), inpShape);
            }
            PTFDeserializer.setupWdwFnEvaluator(wFnDef);
        }
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (PTFDesc.WindowFunctionDef wFnDef : def.getWindowFunctions()) {
            aliases.add(wFnDef.getAlias());
            if (wFnDef.isPivotResult()) {
                fieldOIs.add(((ListObjectInspector)wFnDef.getOI()).getListElementObjectInspector());
                continue;
            }
            fieldOIs.add(wFnDef.getOI());
        }
        PTFDeserializer.addInputColumnsToList(inpShape, aliases, fieldOIs);
        StandardStructObjectInspector wdwOutOI = ObjectInspectorFactory.getStandardStructObjectInspector(aliases, fieldOIs);
        tResolver.setWdwProcessingOutputOI(wdwOutOI);
        this.initialize(def.getOutputShape(), (StructObjectInspector)wdwOutOI);
        tResolver.initializeOutputOI();
    }

    protected void initialize(PTFDesc.PTFQueryInputDef def, StructObjectInspector OI) throws HiveException {
        PTFDesc.ShapeDetails outShape = def.getOutputShape();
        this.initialize(outShape, OI);
    }

    protected void initialize(PTFDesc.PartitionedTableFunctionDef def) throws HiveException {
        PTFDesc.ShapeDetails inpShape = def.getInput().getOutputShape();
        if (def.getArgs() != null) {
            for (PTFDesc.PTFExpressionDef arg : def.getArgs()) {
                this.initialize(arg, inpShape);
            }
        }
        TableFunctionEvaluator tEval = def.getTFunction();
        TableFunctionResolver tResolver = this.constructResolver(def.getResolverClassName());
        tResolver.initialize(this.ptfDesc, def, tEval);
        if (tEval.isTransformsRawInput()) {
            tResolver.initializeRawInputOI();
            this.initialize(def.getRawInputShape(), tEval.getRawInputOI());
        } else {
            def.setRawInputShape(inpShape);
        }
        inpShape = def.getRawInputShape();
        tResolver.initializeOutputOI();
        this.initialize(def.getOutputShape(), tEval.getOutputOI());
    }

    static void setupWdwFnEvaluator(PTFDesc.WindowFunctionDef def) throws HiveException {
        ArrayList<PTFDesc.PTFExpressionDef> args = def.getArgs();
        ArrayList<ObjectInspector> argOIs = new ArrayList<ObjectInspector>();
        ObjectInspector[] funcArgOIs = null;
        if (args != null) {
            for (PTFDesc.PTFExpressionDef arg : args) {
                argOIs.add(arg.getOI());
            }
            funcArgOIs = new ObjectInspector[args.size()];
            funcArgOIs = argOIs.toArray(funcArgOIs);
        }
        GenericUDAFEvaluator wFnEval = def.getWFnEval();
        ObjectInspector OI = wFnEval.init(GenericUDAFEvaluator.Mode.COMPLETE, funcArgOIs);
        def.setWFnEval(wFnEval);
        def.setOI(OI);
    }

    protected void initialize(PTFDesc.BoundaryDef def, PTFDesc.ShapeDetails inpShape) throws HiveException {
        if (def instanceof PTFDesc.ValueBoundaryDef) {
            PTFDesc.ValueBoundaryDef vDef = (PTFDesc.ValueBoundaryDef)def;
            this.initialize(vDef.getExpressionDef(), inpShape);
        }
    }

    protected void initialize(PTFDesc.PTFExpressionDef eDef, PTFDesc.ShapeDetails inpShape) throws HiveException {
        ExprNodeDesc exprNode = eDef.getExprNode();
        ExprNodeEvaluator exprEval = WindowingExprNodeEvaluatorFactory.get(this.llInfo, exprNode);
        ObjectInspector oi = this.initExprNodeEvaluator(exprEval, exprNode, inpShape);
        eDef.setExprEvaluator(exprEval);
        eDef.setOI(oi);
    }

    private ObjectInspector initExprNodeEvaluator(ExprNodeEvaluator exprEval, ExprNodeDesc exprNode, PTFDesc.ShapeDetails inpShape) throws HiveException {
        ObjectInspector outOI = exprEval.initialize(inpShape.getOI());
        List<ExprNodeGenericFuncDesc> llFuncExprs = this.llInfo.getLLFuncExprsInTopExpr(exprNode);
        if (llFuncExprs != null) {
            for (ExprNodeGenericFuncDesc llFuncExpr : llFuncExprs) {
                ExprNodeDesc firstArg = llFuncExpr.getChildren().get(0);
                ExprNodeEvaluator dupExprEval = WindowingExprNodeEvaluatorFactory.get(this.llInfo, firstArg);
                dupExprEval.initialize(inpShape.getOI());
                GenericUDFLeadLag llFn = (GenericUDFLeadLag)llFuncExpr.getGenericUDF();
                llFn.setExprEvaluator(dupExprEval);
            }
        }
        return outOI;
    }

    protected void initialize(PTFDesc.ShapeDetails shp, StructObjectInspector OI) throws HiveException {
        String serdeClassName = shp.getSerdeClassName();
        Properties serDeProps = new Properties();
        LinkedHashMap<String, String> serdePropsMap = new LinkedHashMap<String, String>();
        PTFDeserializer.addOIPropertiestoSerDePropsMap(OI, serdePropsMap);
        for (String serdeName : serdePropsMap.keySet()) {
            serDeProps.setProperty(serdeName, (String)serdePropsMap.get(serdeName));
        }
        try {
            SerDe serDe = (SerDe)SerDeUtils.lookupDeserializer(serdeClassName);
            serDe.initialize(this.hConf, serDeProps);
            shp.setSerde(serDe);
            StructObjectInspector outOI = PTFPartition.setupPartitionOutputOI(serDe, OI);
            shp.setOI(outOI);
        }
        catch (SerDeException se) {
            throw new HiveException(se);
        }
    }

    private static void addInputColumnsToList(PTFDesc.ShapeDetails shape, ArrayList<String> fieldNames, ArrayList<ObjectInspector> fieldOIs) {
        StructObjectInspector OI = shape.getOI();
        for (StructField structField : OI.getAllStructFieldRefs()) {
            fieldNames.add(structField.getFieldName());
            fieldOIs.add(structField.getFieldObjectInspector());
        }
    }

    private TableFunctionResolver constructResolver(String className) throws HiveException {
        try {
            Class<?> rCls = Class.forName(className);
            return (TableFunctionResolver)ReflectionUtils.newInstance(rCls, null);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static void addOIPropertiestoSerDePropsMap(StructObjectInspector OI, Map<String, String> serdePropsMap) {
        if (serdePropsMap == null) {
            return;
        }
        ArrayList<? extends Object>[] tInfo = PTFDeserializer.getTypeMap(OI);
        ArrayList<? extends Object> columnNames = tInfo[0];
        ArrayList<? extends Object> fields = tInfo[1];
        StringBuilder cNames = new StringBuilder();
        StringBuilder cTypes = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            cNames.append(i > 0 ? "," : "");
            cTypes.append(i > 0 ? "," : "");
            cNames.append((String)columnNames.get(i));
            cTypes.append(((TypeInfo)fields.get(i)).getTypeName());
        }
        serdePropsMap.put("columns", cNames.toString());
        serdePropsMap.put("columns.types", cTypes.toString());
    }

    private static ArrayList<? extends Object>[] getTypeMap(StructObjectInspector oi) {
        StructTypeInfo t = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(oi);
        ArrayList<String> fnames = t.getAllStructFieldNames();
        ArrayList<TypeInfo> fields = t.getAllStructFieldTypeInfos();
        return new ArrayList[]{fnames, fields};
    }
}

