/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinCondExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.MapLookupExpression;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NegativeExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;

class ConstExpEvaluator
extends LogicalExpressionVisitor {
    Deque<ConstantExpression> result = new LinkedList<ConstantExpression>();

    ConstExpEvaluator(OperatorPlan plan) throws FrontendException {
        super(plan, new ReverseDependencyOrderWalker(plan));
    }

    private void binaryExpressionConstPrune(LogicalExpression parent) throws FrontendException {
        block37: {
            ConstantExpression newExp;
            ConstantExpression lhs;
            ConstantExpression rhs;
            block39: {
                block50: {
                    byte type;
                    block49: {
                        block48: {
                            block47: {
                                block46: {
                                    block45: {
                                        block44: {
                                            block43: {
                                                block42: {
                                                    block41: {
                                                        block40: {
                                                            block38: {
                                                                block36: {
                                                                    rhs = this.result.pop();
                                                                    lhs = this.result.pop();
                                                                    if (rhs != null && lhs != null) break block36;
                                                                    this.result.push(null);
                                                                    break block37;
                                                                }
                                                                newExp = null;
                                                                if (!(parent instanceof AndExpression)) break block38;
                                                                newExp = new ConstantExpression(this.plan, (Boolean)rhs.getValue() != false && (Boolean)lhs.getValue() != false);
                                                                break block39;
                                                            }
                                                            if (!(parent instanceof OrExpression)) break block40;
                                                            newExp = new ConstantExpression(this.plan, (Boolean)rhs.getValue() != false || (Boolean)lhs.getValue() != false);
                                                            break block39;
                                                        }
                                                        if (!(parent instanceof EqualExpression)) break block41;
                                                        newExp = new ConstantExpression(this.plan, rhs.isEqual(lhs));
                                                        break block39;
                                                    }
                                                    if (!(parent instanceof GreaterThanExpression)) break block42;
                                                    newExp = new ConstantExpression(this.plan, ((Comparable)rhs.getValue()).compareTo((Comparable)lhs.getValue()) > 0);
                                                    break block39;
                                                }
                                                if (!(parent instanceof GreaterThanEqualExpression)) break block43;
                                                newExp = new ConstantExpression(this.plan, ((Comparable)rhs.getValue()).compareTo((Comparable)lhs.getValue()) >= 0);
                                                break block39;
                                            }
                                            if (!(parent instanceof LessThanExpression)) break block44;
                                            newExp = new ConstantExpression(this.plan, ((Comparable)rhs.getValue()).compareTo((Comparable)lhs.getValue()) < 0);
                                            break block39;
                                        }
                                        if (!(parent instanceof LessThanExpression)) break block45;
                                        newExp = new ConstantExpression(this.plan, ((Comparable)rhs.getValue()).compareTo((Comparable)lhs.getValue()) <= 0);
                                        break block39;
                                    }
                                    if (!(parent instanceof AddExpression)) break block46;
                                    type = parent.getFieldSchema().type;
                                    switch (type) {
                                        case 10: {
                                            newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() + (Integer)rhs.getValue());
                                            break;
                                        }
                                        case 15: {
                                            newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() + (Long)rhs.getValue());
                                            break;
                                        }
                                        case 20: {
                                            newExp = new ConstantExpression(this.plan, Float.valueOf(((Float)lhs.getValue()).floatValue() + ((Float)rhs.getValue()).floatValue()));
                                            break;
                                        }
                                        case 25: {
                                            newExp = new ConstantExpression(this.plan, (Double)lhs.getValue() + (Double)rhs.getValue());
                                            break;
                                        }
                                        default: {
                                            throw new FrontendException("Invalid type");
                                        }
                                    }
                                    break block39;
                                }
                                if (!(parent instanceof SubtractExpression)) break block47;
                                type = parent.getFieldSchema().type;
                                switch (type) {
                                    case 10: {
                                        newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() - (Integer)rhs.getValue());
                                        break;
                                    }
                                    case 15: {
                                        newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() - (Long)rhs.getValue());
                                        break;
                                    }
                                    case 20: {
                                        newExp = new ConstantExpression(this.plan, Float.valueOf(((Float)lhs.getValue()).floatValue() - ((Float)rhs.getValue()).floatValue()));
                                        break;
                                    }
                                    case 25: {
                                        newExp = new ConstantExpression(this.plan, (Double)lhs.getValue() - (Double)rhs.getValue());
                                        break;
                                    }
                                    default: {
                                        throw new FrontendException("Invalid type");
                                    }
                                }
                                break block39;
                            }
                            if (!(parent instanceof MultiplyExpression)) break block48;
                            type = parent.getFieldSchema().type;
                            switch (type) {
                                case 10: {
                                    newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() * (Integer)rhs.getValue());
                                    break;
                                }
                                case 15: {
                                    newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() * (Long)rhs.getValue());
                                    break;
                                }
                                case 20: {
                                    newExp = new ConstantExpression(this.plan, Float.valueOf(((Float)lhs.getValue()).floatValue() * ((Float)rhs.getValue()).floatValue()));
                                    break;
                                }
                                case 25: {
                                    newExp = new ConstantExpression(this.plan, (Double)lhs.getValue() * (Double)rhs.getValue());
                                    break;
                                }
                                default: {
                                    throw new FrontendException("Invalid type");
                                }
                            }
                            break block39;
                        }
                        if (!(parent instanceof ModExpression)) break block49;
                        type = parent.getFieldSchema().type;
                        switch (type) {
                            case 10: {
                                newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() % (Integer)rhs.getValue());
                                break;
                            }
                            case 15: {
                                newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() % (Long)rhs.getValue());
                                break;
                            }
                            default: {
                                throw new FrontendException("Invalid type");
                            }
                        }
                        break block39;
                    }
                    if (!(parent instanceof DivideExpression)) break block50;
                    type = parent.getFieldSchema().type;
                    switch (type) {
                        case 10: {
                            if ((Integer)rhs.getValue() != 0) {
                                newExp = new ConstantExpression(this.plan, (Integer)lhs.getValue() / (Integer)rhs.getValue());
                                break;
                            }
                            break block39;
                        }
                        case 15: {
                            if ((Long)rhs.getValue() != 0L) {
                                newExp = new ConstantExpression(this.plan, (Long)lhs.getValue() / (Long)rhs.getValue());
                                break;
                            }
                            break block39;
                        }
                        case 20: {
                            if (((Float)rhs.getValue()).floatValue() != 0.0f) {
                                newExp = new ConstantExpression(this.plan, Float.valueOf(((Float)lhs.getValue()).floatValue() / ((Float)rhs.getValue()).floatValue()));
                                break;
                            }
                            break block39;
                        }
                        case 25: {
                            if ((Double)rhs.getValue() != 0.0) {
                                newExp = new ConstantExpression(this.plan, (Double)lhs.getValue() / (Double)rhs.getValue());
                                break;
                            }
                            break block39;
                        }
                        default: {
                            throw new FrontendException("Invalid type");
                        }
                    }
                    break block39;
                }
                throw new FrontendException("Invalid instance type.");
            }
            if (newExp != null) {
                this.plan.disconnect(parent, rhs);
                this.plan.remove(rhs);
                this.plan.disconnect(parent, lhs);
                this.plan.remove(lhs);
                this.plan.add(newExp);
                List<Operator> predList = this.plan.getPredecessors(parent);
                if (predList != null) {
                    Operator[] preds;
                    Operator[] arr$ = preds = predList.toArray(new Operator[0]);
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Operator p;
                        Operator pred = p = arr$[i$];
                        Pair<Integer, Integer> pos = this.plan.disconnect(pred, parent);
                        this.plan.connect(pred, (Integer)pos.first, newExp, (Integer)pos.second);
                    }
                }
                this.plan.remove(parent);
                this.result.push(newExp);
            } else {
                this.result.push(null);
            }
        }
    }

    private void unaryExpressionConstPrune(LogicalExpression op) throws FrontendException {
        ConstantExpression operand = this.result.pop();
        if (operand == null) {
            this.result.push(null);
            return;
        }
        if (op instanceof CastExpression) {
            this.result.push(null);
        } else {
            ConstantExpression newExp;
            this.plan.remove(operand);
            this.plan.remove(op);
            if (op instanceof NotExpression) {
                newExp = new ConstantExpression(this.plan, (Boolean)operand.getValue() == false);
            } else if (op instanceof IsNullExpression) {
                newExp = new ConstantExpression(this.plan, operand.getValue() == null);
            } else if (op instanceof NegativeExpression) {
                byte type = operand.getFieldSchema().type;
                switch (type) {
                    case 10: {
                        newExp = new ConstantExpression(this.plan, -1 * (Integer)operand.getValue());
                        break;
                    }
                    case 15: {
                        newExp = new ConstantExpression(this.plan, -1L * (Long)operand.getValue());
                        break;
                    }
                    case 20: {
                        newExp = new ConstantExpression(this.plan, Float.valueOf(-1.0f * ((Float)operand.getValue()).floatValue()));
                        break;
                    }
                    case 25: {
                        newExp = new ConstantExpression(this.plan, -1.0 * (double)((Integer)operand.getValue()).intValue());
                        break;
                    }
                    default: {
                        throw new FrontendException("Invalid type");
                    }
                }
            } else {
                throw new FrontendException("Invalid instance type.");
            }
            this.plan.add(newExp);
            this.result.push(newExp);
        }
    }

    private void noConstPrune(LogicalExpression op) throws FrontendException {
        List<Operator> sucs = op.getPlan().getSuccessors(op);
        int nSucs = sucs == null ? 0 : sucs.size();
        for (int i = 0; i < nSucs; ++i) {
            this.result.pop();
        }
        this.result.push(null);
    }

    @Override
    public void visit(ConstantExpression constant) throws FrontendException {
        this.result.push(constant);
    }

    @Override
    public void visit(AndExpression andExpr) throws FrontendException {
        this.binaryExpressionConstPrune(andExpr);
    }

    @Override
    public void visit(OrExpression orExpr) throws FrontendException {
        this.binaryExpressionConstPrune(orExpr);
    }

    @Override
    public void visit(EqualExpression equal) throws FrontendException {
        this.binaryExpressionConstPrune(equal);
    }

    @Override
    public void visit(ProjectExpression project) throws FrontendException {
        this.noConstPrune(project);
    }

    @Override
    public void visit(CastExpression cast) throws FrontendException {
        this.unaryExpressionConstPrune(cast);
    }

    @Override
    public void visit(GreaterThanExpression greaterThanExpression) throws FrontendException {
        this.binaryExpressionConstPrune(greaterThanExpression);
    }

    @Override
    public void visit(NotExpression op) throws FrontendException {
        this.unaryExpressionConstPrune(op);
    }

    @Override
    public void visit(IsNullExpression op) throws FrontendException {
        this.unaryExpressionConstPrune(op);
    }

    @Override
    public void visit(NegativeExpression op) throws FrontendException {
        this.unaryExpressionConstPrune(op);
    }

    @Override
    public void visit(AddExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    @Override
    public void visit(SubtractExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    @Override
    public void visit(ModExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    @Override
    public void visit(MultiplyExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    @Override
    public void visit(DivideExpression op) throws FrontendException {
        this.binaryExpressionConstPrune(op);
    }

    @Override
    public void visit(MapLookupExpression op) throws FrontendException {
        this.noConstPrune(op);
    }

    @Override
    public void visit(BinCondExpression op) throws FrontendException {
        this.noConstPrune(op);
    }

    @Override
    public void visit(UserFuncExpression op) throws FrontendException {
        this.noConstPrune(op);
    }

    @Override
    public void visit(DereferenceExpression bagDerefenceExpression) throws FrontendException {
        this.noConstPrune(bagDerefenceExpression);
    }

    @Override
    public void visit(RegexExpression op) throws FrontendException {
        this.noConstPrune(op);
    }
}

