/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.LoadCaster;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.impl.util.LogUtils;

public class CastUtils {
    private static Integer mMaxInt = Integer.MAX_VALUE;
    private static Long mMaxLong = Long.MAX_VALUE;
    protected static final Log mLog = LogFactory.getLog(CastUtils.class);

    public static Object convertToType(LoadCaster caster, byte[] bytes, ResourceSchema.ResourceFieldSchema fieldSchema, byte dataType) throws IOException {
        switch (dataType) {
            case 120: {
                return caster.bytesToBag(bytes, fieldSchema);
            }
            case 50: {
                return new DataByteArray(bytes);
            }
            case 55: {
                return caster.bytesToCharArray(bytes);
            }
            case 25: {
                return caster.bytesToDouble(bytes);
            }
            case 20: {
                return caster.bytesToFloat(bytes);
            }
            case 10: {
                return caster.bytesToInteger(bytes);
            }
            case 15: {
                return caster.bytesToLong(bytes);
            }
            case 5: {
                return caster.bytesToBoolean(bytes);
            }
            case 30: {
                return caster.bytesToDateTime(bytes);
            }
            case 100: {
                return caster.bytesToMap(bytes);
            }
            case 110: {
                return caster.bytesToTuple(bytes, fieldSchema);
            }
        }
        throw new IOException("Unknown type " + dataType);
    }

    public static Double stringToDouble(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            LogUtils.warn(CastUtils.class, "Unable to interpret value " + str + " in field being " + "converted to double, caught NumberFormatException <" + e.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, mLog);
            return null;
        }
    }

    public static Float stringToFloat(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(str));
        }
        catch (NumberFormatException e) {
            LogUtils.warn(CastUtils.class, "Unable to interpret value " + str + " in field being " + "converted to float, caught NumberFormatException <" + e.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, mLog);
            return null;
        }
    }

    public static Integer stringToInteger(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            try {
                Double d = Double.valueOf(str);
                if (d > mMaxInt.doubleValue() + 1.0) {
                    LogUtils.warn(CastUtils.class, "Value " + d + " too large for integer", PigWarning.TOO_LARGE_FOR_INT, mLog);
                    return null;
                }
                return d.intValue();
            }
            catch (NumberFormatException nfe2) {
                LogUtils.warn(CastUtils.class, "Unable to interpret value " + str + " in field being " + "converted to int, caught NumberFormatException <" + e.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, mLog);
                return null;
            }
        }
    }

    public static Long stringToLong(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            try {
                Double d = Double.valueOf(str);
                if (d > mMaxLong.doubleValue() + 1.0) {
                    LogUtils.warn(CastUtils.class, "Value " + d + " too large for long", PigWarning.TOO_LARGE_FOR_INT, mLog);
                    return null;
                }
                return d.longValue();
            }
            catch (NumberFormatException nfe2) {
                LogUtils.warn(CastUtils.class, "Unable to interpret value " + str + " in field being " + "converted to long, caught NumberFormatException <" + nfe2.getMessage() + "> field discarded", PigWarning.FIELD_DISCARDED_TYPE_CONVERSION_FAILED, mLog);
                return null;
            }
        }
    }

    public static Boolean stringToBoolean(String str) {
        if (str == null) {
            return null;
        }
        if (str.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (str.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }
}

