/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.builtin.ToDate2ARGS;
import org.apache.pig.builtin.ToDate3ARGS;
import org.apache.pig.builtin.ToDateISO;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ToDate
extends EvalFunc<DateTime> {
    @Override
    public DateTime exec(Tuple input) throws IOException {
        return new DateTime((Object)DataType.toLong(input.get(0)));
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), input), 30));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 15));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(ToDateISO.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(ToDate2ARGS.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(ToDate3ARGS.class.getName(), s));
        return funcList;
    }

    public static DateTimeZone extractDateTimeZone(String dtStr) {
        Pattern pattern = Pattern.compile("(Z|(?<=(T[0-9\\.:]{0,12}))((\\+|-)\\d{2}(:?\\d{2})?))$");
        Matcher matcher = pattern.matcher(dtStr);
        if (matcher.find()) {
            String dtzStr = matcher.group();
            if (dtzStr.equals("Z")) {
                return DateTimeZone.forOffsetMillis((int)DateTimeZone.UTC.getOffset(null));
            }
            return DateTimeZone.forOffsetMillis((int)DateTimeZone.forID((String)dtzStr).getOffset(null));
        }
        return null;
    }
}

