/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class TOP
extends EvalFunc<DataBag>
implements Algebraic {
    private static final Log log = LogFactory.getLog(TOP.class);
    static BagFactory mBagFactory = BagFactory.getInstance();
    static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private Random randomizer = new Random();

    @Override
    public DataBag exec(Tuple tuple) throws IOException {
        if (tuple == null || tuple.size() < 3) {
            return null;
        }
        try {
            int n = (Integer)tuple.get(0);
            int fieldNum = (Integer)tuple.get(1);
            DataBag inputBag = (DataBag)tuple.get(2);
            if (inputBag == null) {
                return null;
            }
            PriorityQueue<Tuple> store = new PriorityQueue<Tuple>(n + 1, new TupleComparator(fieldNum));
            TOP.updateTop(store, n, inputBag);
            DataBag outputBag = mBagFactory.newDefaultBag();
            for (Tuple t : store) {
                outputBag.add(t);
            }
            if (log.isDebugEnabled() && this.randomizer.nextInt(1000) == 1) {
                log.debug((Object)"outputting a bag: ");
                for (Tuple t : outputBag) {
                    log.debug((Object)("outputting " + t.toDelimitedString("\t")));
                }
                log.debug((Object)"==================");
            }
            return outputBag;
        }
        catch (ExecException e) {
            throw new RuntimeException("ExecException executing function: ", e);
        }
        catch (Exception e) {
            throw new RuntimeException("General Exception executing function: ", e);
        }
    }

    protected static void updateTop(PriorityQueue<Tuple> store, int limit, DataBag inputBag) {
        for (Tuple t : inputBag) {
            store.add(t);
            if (store.size() <= limit) continue;
            store.poll();
        }
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<Schema.FieldSchema> fields = new ArrayList<Schema.FieldSchema>(3);
        fields.add(new Schema.FieldSchema(null, 10));
        fields.add(new Schema.FieldSchema(null, 10));
        fields.add(new Schema.FieldSchema(null, 120));
        FuncSpec funcSpec = new FuncSpec(this.getClass().getName(), new Schema(fields));
        ArrayList<FuncSpec> funcSpecs = new ArrayList<FuncSpec>(1);
        funcSpecs.add(funcSpec);
        return funcSpecs;
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            if (input.size() < 3) {
                return null;
            }
            return new Schema(input.getField(2));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermed.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    public static class Final
    extends EvalFunc<DataBag> {
        private static final Log log = LogFactory.getLog(Final.class);
        private final Random randomizer = new Random();

        @Override
        public DataBag exec(Tuple tuple) throws IOException {
            if (tuple == null || tuple.size() < 1) {
                return null;
            }
            try {
                DataBag bagOfIntermediates = (DataBag)tuple.get(0);
                Iterator<Tuple> intermediateIterator = bagOfIntermediates.iterator();
                if (!intermediateIterator.hasNext()) {
                    return null;
                }
                Tuple peekTuple = intermediateIterator.next();
                if (peekTuple == null || peekTuple.size() < 3) {
                    return null;
                }
                int n = (Integer)peekTuple.get(0);
                int fieldNum = (Integer)peekTuple.get(1);
                DataBag inputBag = (DataBag)peekTuple.get(2);
                boolean allInputBagsNull = true;
                PriorityQueue<Tuple> store = new PriorityQueue<Tuple>(n + 1, new TupleComparator(fieldNum));
                if (inputBag != null) {
                    allInputBagsNull = false;
                    TOP.updateTop(store, n, inputBag);
                }
                while (intermediateIterator.hasNext()) {
                    Tuple t = intermediateIterator.next();
                    if (t == null || t.size() < 3 || (inputBag = (DataBag)t.get(2)) == null) continue;
                    allInputBagsNull = false;
                    TOP.updateTop(store, n, inputBag);
                }
                if (allInputBagsNull) {
                    return null;
                }
                DataBag outputBag = mBagFactory.newDefaultBag();
                for (Tuple t : store) {
                    outputBag.add(t);
                }
                if (log.isDebugEnabled() && this.randomizer.nextInt(1000) == 1) {
                    for (Tuple t : outputBag) {
                        log.debug((Object)("outputting " + t.toDelimitedString("\t")));
                    }
                }
                return outputBag;
            }
            catch (ExecException e) {
                throw new RuntimeException("ExecException executing function: ", e);
            }
            catch (Exception e) {
                throw new RuntimeException("General Exception executing function: " + e);
            }
        }
    }

    public static class Intermed
    extends EvalFunc<Tuple> {
        private static final Log log = LogFactory.getLog(Intermed.class);
        private final Random randomizer = new Random();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            if (input == null || input.size() < 1) {
                return null;
            }
            try {
                DataBag bagOfIntermediates = (DataBag)input.get(0);
                Iterator<Tuple> intermediateIterator = bagOfIntermediates.iterator();
                if (!intermediateIterator.hasNext()) {
                    return null;
                }
                Tuple peekTuple = intermediateIterator.next();
                if (peekTuple == null || peekTuple.size() < 3) {
                    return null;
                }
                int n = (Integer)peekTuple.get(0);
                int fieldNum = (Integer)peekTuple.get(1);
                DataBag inputBag = (DataBag)peekTuple.get(2);
                boolean allInputBagsNull = true;
                PriorityQueue<Tuple> store = new PriorityQueue<Tuple>(n + 1, new TupleComparator(fieldNum));
                if (inputBag != null) {
                    allInputBagsNull = false;
                    TOP.updateTop(store, n, inputBag);
                }
                while (intermediateIterator.hasNext()) {
                    Tuple t = intermediateIterator.next();
                    if (t == null || t.size() < 3 || (inputBag = (DataBag)t.get(2)) == null) continue;
                    allInputBagsNull = false;
                    TOP.updateTop(store, n, inputBag);
                }
                Tuple retTuple = mTupleFactory.newTuple(3);
                retTuple.set(0, n);
                retTuple.set(1, fieldNum);
                DataBag outputBag = null;
                if (!allInputBagsNull) {
                    outputBag = mBagFactory.newDefaultBag();
                    for (Tuple t : store) {
                        outputBag.add(t);
                    }
                }
                retTuple.set(2, outputBag);
                if (log.isDebugEnabled() && this.randomizer.nextInt(1000) == 1) {
                    log.debug((Object)("outputting " + retTuple.toDelimitedString("\t")));
                }
                return retTuple;
            }
            catch (ExecException e) {
                throw new RuntimeException("ExecException executing function: ", e);
            }
            catch (Exception e) {
                throw new RuntimeException("General Exception executing function: " + e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple tuple) throws IOException {
            if (tuple == null || tuple.size() < 3) {
                return null;
            }
            try {
                int n = (Integer)tuple.get(0);
                int fieldNum = (Integer)tuple.get(1);
                DataBag inputBag = (DataBag)tuple.get(2);
                if (inputBag == null) {
                    return null;
                }
                Tuple retTuple = mTupleFactory.newTuple(3);
                DataBag outputBag = mBagFactory.newDefaultBag();
                for (Tuple t : inputBag) {
                    outputBag.add(t);
                }
                retTuple.set(0, n);
                retTuple.set(1, fieldNum);
                retTuple.set(2, outputBag);
                return retTuple;
            }
            catch (Exception e) {
                throw new RuntimeException("General Exception executing function: " + e);
            }
        }
    }

    static class TupleComparator
    implements Comparator<Tuple> {
        private final int fieldNum;
        private byte datatype;
        private boolean typeFound = false;

        public TupleComparator(int fieldNum) {
            this.fieldNum = fieldNum;
        }

        @Override
        public int compare(Tuple o1, Tuple o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            try {
                Object field1 = o1.get(this.fieldNum);
                Object field2 = o2.get(this.fieldNum);
                if (!this.typeFound) {
                    this.datatype = DataType.findType(field1);
                    this.typeFound = true;
                }
                return DataType.compare(field1, field2, this.datatype, this.datatype);
            }
            catch (ExecException e) {
                throw new RuntimeException("Error while comparing o1:" + o1 + " and o2:" + o2, e);
            }
        }
    }
}

