/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class POOptimizedForEach
extends POForEach {
    private static final long serialVersionUID = 1L;

    public POOptimizedForEach(OperatorKey k) {
        this(k, -1, null, null);
    }

    public POOptimizedForEach(OperatorKey k, int rp, List inp) {
        this(k, rp, inp, null);
    }

    public POOptimizedForEach(OperatorKey k, int rp) {
        this(k, rp, null, null);
    }

    public POOptimizedForEach(OperatorKey k, List inp) {
        this(k, -1, inp, null);
    }

    public POOptimizedForEach(OperatorKey k, int rp, List<PhysicalPlan> inp, List<Boolean> isToBeFlattened) {
        super(k, rp);
        this.setUpFlattens(isToBeFlattened);
        this.inputPlans = inp;
        this.getLeaves();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPOOptimizedForEach(this);
    }

    @Override
    public String name() {
        String fString = this.getFlatStr();
        return "Optimized For Each(" + fString + ")" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result res = null;
        Object inp = null;
        if (this.processingPlan) {
            while (true) {
                res = this.processPlan();
                if (res.returnStatus == 0) {
                    return res;
                }
                if (res.returnStatus == 3) {
                    this.processingPlan = false;
                    for (PhysicalPlan plan : this.inputPlans) {
                        plan.detachInput();
                    }
                    return res;
                }
                if (res.returnStatus == 2) {
                    return res;
                }
                if (res.returnStatus != 1) continue;
            }
        }
        this.attachInputToPlans(this.input);
        this.detachInput();
        res = this.processPlan();
        this.processingPlan = true;
        return res;
    }

    @Override
    public POOptimizedForEach clone() throws CloneNotSupportedException {
        ArrayList<PhysicalPlan> plans = new ArrayList<PhysicalPlan>(this.inputPlans.size());
        for (PhysicalPlan plan : this.inputPlans) {
            plans.add(plan.clone());
        }
        ArrayList<Boolean> flattens = null;
        if (this.isToBeFlattenedArray != null) {
            flattens = new ArrayList<Boolean>(this.isToBeFlattenedArray.length);
            for (boolean b : this.isToBeFlattenedArray) {
                flattens.add(b);
            }
        }
        return new POOptimizedForEach(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism, plans, flattens);
    }
}

