/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.test.olap;

import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.Expression;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.navi.ExpressionParser;
import com.tonbeller.jpivot.test.olap.TestExtensionSupport;
import com.tonbeller.jpivot.test.olap.TestMember;

public class TestExpressionParser
extends TestExtensionSupport
implements ExpressionParser {
    @Override
    public Expression parse(String name) throws ExpressionParser.InvalidSyntaxException {
        Dimension[] dims = this.model().getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            Dimension d = dims[i];
            if (name.equals(d.getLabel())) {
                return d;
            }
            Expression e = this.findHierarchies(name, d.getHierarchies());
            if (e == null) continue;
            return e;
        }
        TestMember tm = new TestMember();
        tm.setLabel(name);
        return tm;
    }

    private Expression findHierarchies(String name, Hierarchy[] hiers) {
        for (int i = 0; i < hiers.length; ++i) {
            Hierarchy h = hiers[i];
            if (name.equals(h.getLabel())) {
                return h;
            }
            Expression e = this.findLevels(name, h.getLevels());
            if (e == null) continue;
            return e;
        }
        return null;
    }

    private Expression findLevels(String name, Level[] levels) {
        for (int i = 0; i < levels.length; ++i) {
            Level l = levels[i];
            if (!name.equals(l.getLabel())) continue;
            return l;
        }
        return null;
    }

    @Override
    public String unparse(Expression expr) {
        return ((Displayable)((Object)expr)).getLabel();
    }

    @Override
    public Member lookupMember(String uniqueName) throws ExpressionParser.InvalidSyntaxException {
        Expression obj = this.parse(uniqueName);
        if (obj instanceof Member) {
            return (Member)obj;
        }
        return null;
    }

    @Override
    public Level lookupLevel(String uniqueName) throws ExpressionParser.InvalidSyntaxException {
        Expression obj = this.parse(uniqueName);
        if (obj instanceof Level) {
            return (Level)obj;
        }
        return null;
    }

    @Override
    public Hierarchy lookupHierarchy(String uniqueName) throws ExpressionParser.InvalidSyntaxException {
        Expression obj = this.parse(uniqueName);
        if (obj instanceof Hierarchy) {
            return (Hierarchy)obj;
        }
        return null;
    }

    @Override
    public Dimension lookupDimension(String uniqueName) throws ExpressionParser.InvalidSyntaxException {
        Expression obj = this.parse(uniqueName);
        if (obj instanceof Dimension) {
            return (Dimension)obj;
        }
        return null;
    }
}

