/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.span;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.table.span.NoSpanConfig;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanConfig;
import com.tonbeller.jpivot.table.span.SpanHeaderFactory;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SpanCalc {
    private static final Logger logger = Logger.getLogger(SpanCalc.class);
    int positionCount;
    int hierarchyCount;
    Span[][] spans;
    boolean initialized = false;
    SpanConfig config = new NoSpanConfig();
    boolean[][] forcePositionBreak;

    public SpanCalc(Span[][] spans) {
        this.spans = spans;
    }

    public SpanCalc(Axis axis) {
        this.positionCount = axis.getPositions().size();
        this.hierarchyCount = this.positionCount > 0 ? ((Position)axis.getPositions().get(0)).getMembers().length : 0;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("creating SpanCalc, positionCount = " + this.positionCount + ", hierarchyCount = " + this.hierarchyCount));
        }
        this.spans = new Span[this.positionCount][];
        for (int i = 0; i < this.positionCount; ++i) {
            this.spans[i] = new Span[this.hierarchyCount];
        }
        Iterator it = axis.getPositions().iterator();
        for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
            Position p = (Position)it.next();
            this.createSpansFromAxis(axis, p, posIndex, this.spans[posIndex]);
        }
    }

    void createSpansFromAxis(Axis axis, Position position, int posIndex, Span[] spans) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("creating Span for position " + posIndex));
        }
        Member[] members = position.getMembers();
        for (int hierIndex = 0; hierIndex < this.hierarchyCount; ++hierIndex) {
            Member member = members[hierIndex];
            spans[hierIndex] = new Span(axis, position, member);
        }
    }

    void initialize() {
        if (!this.initialized) {
            this.positionCount = this.spans.length;
            this.hierarchyCount = this.positionCount > 0 ? this.spans[0].length : 0;
            this.initSpans();
            this.calcSpans();
            this.calcIndent();
            this.initialized = true;
        }
    }

    void initSpans() {
        for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
            for (int hierIndex = 0; hierIndex < this.hierarchyCount; ++hierIndex) {
                this.spans[posIndex][hierIndex].initialize(posIndex, hierIndex);
            }
        }
    }

    void calcSpans() {
        logger.info((Object)"calcSpans");
        this.forcePositionBreak = new boolean[this.positionCount][this.hierarchyCount];
        for (int hierIndex = 0; hierIndex < this.hierarchyCount; ++hierIndex) {
            for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
                int count;
                Span span = this.spans[posIndex][hierIndex];
                if (!span.isSignificant()) continue;
                int dir = this.config.chooseSpanDirection(span);
                if (dir == 1) {
                    this.makeHierSpan(span, 1);
                    this.addForcePositionBreak(span);
                    continue;
                }
                if (dir == 2) {
                    this.makePosSpan(span, 1);
                    this.addForcePositionBreak(span);
                    continue;
                }
                if (dir == 3) {
                    count = this.makeHierSpan(span, 1);
                    this.makePosSpan(span, count);
                    this.addForcePositionBreak(span);
                    continue;
                }
                if (dir != 4) continue;
                count = this.makePosSpan(span, 1);
                this.makeHierSpan(span, count);
                this.addForcePositionBreak(span);
            }
        }
    }

    int makeHierSpan(Span span, int posSpans) {
        logger.debug((Object)"makeHierSpan");
        int pi = span.positionIndex;
        int spanCount = 1;
        for (int hi = span.hierarchyIndex + 1; hi < this.hierarchyCount; ++hi) {
            Span s;
            int i;
            boolean equal = true;
            for (i = 0; i < posSpans; ++i) {
                s = this.spans[pi + i][hi];
                equal = equal && this.config.equals(span, s);
            }
            if (!equal) break;
            ++span.hierarchySpan;
            ++spanCount;
            for (i = 0; i < posSpans; ++i) {
                s = this.spans[pi + i][hi];
                s.significant = false;
                s.positionSpan = 0;
                s.hierarchySpan = 0;
            }
        }
        return spanCount;
    }

    int makePosSpan(Span span, int hierSpans) {
        logger.debug((Object)"makePosSpan");
        int hi = span.hierarchyIndex;
        int spanCount = 1;
        for (int pi = span.positionIndex + 1; pi < this.positionCount && !this.forcePositionBreak[pi][hi]; ++pi) {
            Span s;
            int i;
            boolean equal = true;
            for (i = 0; i < hierSpans; ++i) {
                s = this.spans[pi][hi + i];
                equal = equal && this.config.equals(span, s);
            }
            if (!equal) break;
            ++span.positionSpan;
            ++spanCount;
            for (i = 0; i < hierSpans; ++i) {
                s = this.spans[pi][hi + i];
                s.significant = false;
                s.positionSpan = 0;
                s.hierarchySpan = 0;
            }
        }
        return spanCount;
    }

    void addForcePositionBreak(Span span) {
        int pi = span.positionIndex + span.positionSpan;
        for (int hi = span.hierarchyIndex + span.hierarchySpan; pi < this.positionCount && hi < this.hierarchyCount; ++hi) {
            this.forcePositionBreak[pi][hi] = true;
        }
    }

    public SpanCalc createPositionHeader(SpanHeaderFactory shf) {
        logger.info((Object)"createPositionHeader");
        if (!this.initialized) {
            this.initialize();
        }
        if (this.hierarchyCount == 0 || this.positionCount == 0) {
            return null;
        }
        Span[][] header = new Span[1][this.hierarchyCount];
        header[0][0] = shf.create(this.spans[0][0]);
        for (int hi = 1; hi < this.hierarchyCount; ++hi) {
            int pi;
            for (pi = 0; pi < this.positionCount; ++pi) {
                Span prevSpan = this.spans[pi][hi - 1];
                Span curSpan = this.spans[pi][hi];
                if (this.config.equals(prevSpan, curSpan)) continue;
                prevSpan = curSpan;
                header[0][hi] = shf.create(curSpan);
                break;
            }
            if (pi != this.positionCount) continue;
            header[0][hi] = shf.create(this.spans[0][hi]);
        }
        return new SpanCalc(header);
    }

    public void addHierarchyHeader(SpanHeaderFactory shf, boolean removeDuplicates) {
        logger.info((Object)"addHierarchyHeader");
        boolean[] keep = new boolean[this.hierarchyCount * 2];
        this.createHeaderSpans(shf, keep);
        int newHierarchyCount = 0;
        for (int i = 0; i < keep.length; ++i) {
            if (!keep[i]) continue;
            ++newHierarchyCount;
        }
        this.removeDuplicateHeaders(keep, newHierarchyCount);
        this.initialized = false;
    }

    void removeDuplicateHeaders(boolean[] keep, int newHierarchyCount) {
        logger.info((Object)"removeDuplicateHeaders");
        for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
            Span[] oldSpans = this.spans[posIndex];
            Span[] newSpans = new Span[newHierarchyCount];
            int newHierIndex = 0;
            for (int oldHierIndex = 0; oldHierIndex < oldSpans.length; ++oldHierIndex) {
                if (!keep[oldHierIndex]) continue;
                Span span = oldSpans[oldHierIndex];
                newSpans[newHierIndex++] = span;
            }
            this.spans[posIndex] = newSpans;
        }
    }

    void createHeaderSpans(SpanHeaderFactory shf, boolean[] keep) {
        logger.info((Object)"createHeaderSpans");
        for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
            Span[] newSpans = new Span[this.hierarchyCount * 2];
            int newIndex = 0;
            Span prevHeaderSpan = null;
            for (int hierIndex = 0; hierIndex < this.hierarchyCount; ++hierIndex) {
                Span span = this.spans[posIndex][hierIndex];
                Span curHeaderSpan = shf.create(span);
                if (prevHeaderSpan == null || !this.config.equals(prevHeaderSpan, curHeaderSpan)) {
                    keep[newIndex] = true;
                    newSpans[newIndex++] = curHeaderSpan;
                    prevHeaderSpan = curHeaderSpan;
                } else {
                    newSpans[newIndex++] = (Span)span.clone();
                }
                keep[newIndex] = true;
                newSpans[newIndex++] = span;
            }
            this.spans[posIndex] = newSpans;
        }
    }

    public Span getSpan(int positionIndex, int hierarchyIndex) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.spans[positionIndex][hierarchyIndex];
    }

    public int getHierarchyCount() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.hierarchyCount;
    }

    public int getPositionCount() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.positionCount;
    }

    public SpanConfig getConfig() {
        return this.config;
    }

    public void setConfig(SpanConfig config) {
        this.initialized = false;
        this.config = config;
    }

    public Span[][] getSpans() {
        return this.spans;
    }

    public void setSpans(Span[][] spans) {
        this.spans = spans;
        this.initialized = false;
    }

    void calcIndent() {
        logger.info((Object)"calcIndent");
        for (int hi = 0; hi < this.hierarchyCount; ++hi) {
            Member m;
            Span s;
            int pi;
            int minRootDistance = Integer.MAX_VALUE;
            for (pi = 0; pi < this.positionCount; ++pi) {
                s = this.spans[pi][hi];
                if (!s.isMember() || (m = s.getMember()).getRootDistance() >= minRootDistance) continue;
                minRootDistance = m.getRootDistance();
            }
            for (pi = 0; pi < this.positionCount; ++pi) {
                s = this.spans[pi][hi];
                if (s.isMember()) {
                    m = s.getMember();
                    s.setIndent(m.getRootDistance() - minRootDistance);
                    continue;
                }
                s.setIndent(0);
            }
        }
    }

    public static SpanCalc appendBelow(SpanCalc above, SpanCalc below) {
        int hi;
        int pi;
        logger.info((Object)"appendBelow");
        if (above == null) {
            return below;
        }
        if (below == null) {
            return above;
        }
        if (above.getHierarchyCount() != below.getHierarchyCount()) {
            throw new IllegalArgumentException("sizes dont match");
        }
        int HI = above.getHierarchyCount();
        Span[][] a = above.spans;
        Span[][] b = below.spans;
        Span[][] s = new Span[a.length + b.length][];
        for (pi = 0; pi < a.length; ++pi) {
            s[pi] = new Span[HI];
            for (hi = 0; hi < HI; ++hi) {
                s[pi][hi] = a[pi][hi];
            }
        }
        for (pi = 0; pi < b.length; ++pi) {
            s[pi + a.length] = new Span[HI];
            for (hi = 0; hi < HI; ++hi) {
                s[pi + a.length][hi] = b[pi][hi];
            }
        }
        return new SpanCalc(s);
    }
}

