/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.table.AxisBuilderSupport;
import com.tonbeller.jpivot.table.RowAxisBuilder;
import com.tonbeller.jpivot.table.RowAxisConfig;
import com.tonbeller.jpivot.table.SpanBuilderImpl;
import com.tonbeller.jpivot.table.span.HierarchyHeaderFactory;
import com.tonbeller.jpivot.table.span.IgnorePropertiesHierarchyHeaderFactory;
import com.tonbeller.jpivot.table.span.LevelHeaderFactory;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanCalc;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class RowAxisBuilderImpl
extends AxisBuilderSupport
implements RowAxisBuilder,
RowAxisConfig {
    int positionHeader;
    SpanCalc headerSpans;
    private static final Logger logger = Logger.getLogger(RowAxisBuilderImpl.class);

    public RowAxisBuilderImpl() {
        super(new SpanBuilderImpl("row-heading", "heading-heading"));
        this.setMemberIndent(true);
        this.setShowParentMembers(false);
        this.setHierarchyHeader(0);
        this.setMemberSpan(3);
        this.setHeaderSpan(3);
        this.setPositionHeader(1);
    }

    @Override
    public void buildRow(Element parent, int rowIndex) {
        boolean even = rowIndex % 2 == 0;
        for (int i = 0; i < this.spanCalc.getHierarchyCount(); ++i) {
            Span span = this.spanCalc.getSpan(rowIndex, i);
            if (!span.isSignificant()) continue;
            int rowspan = span.getPositionSpan();
            int colspan = span.getHierarchySpan();
            this.buildHeading(parent, span, rowspan, colspan, even);
        }
    }

    @Override
    public int getColumnCount() {
        return this.spanCalc.getHierarchyCount();
    }

    @Override
    public int getRowCount() {
        return this.spanCalc.getPositionCount();
    }

    @Override
    public int getPositionHeader() {
        return this.positionHeader;
    }

    @Override
    public void setPositionHeader(int positionHeader) {
        this.positionHeader = positionHeader;
        this.setDirty(true);
    }

    @Override
    public void buildHeaderRow(Element parent, int rowIndex) {
        boolean even = rowIndex % 2 == 0;
        for (int i = 0; i < this.headerSpans.getHierarchyCount(); ++i) {
            Span span = this.headerSpans.getSpan(rowIndex, i);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("building header row: " + span));
            }
            if (!span.isSignificant()) continue;
            int rowspan = span.getPositionSpan();
            int colspan = span.getHierarchySpan();
            this.buildHeading(parent, span, rowspan, colspan, even);
        }
    }

    @Override
    public int getHeaderRowCount() {
        if (this.headerSpans == null) {
            return 0;
        }
        return this.headerSpans.getPositionCount();
    }

    @Override
    public SpanCalc getHeaderSpanCalc() {
        return this.headerSpans;
    }

    @Override
    public void initialize(Axis axis) {
        super.initialize(axis);
        switch (this.positionHeader) {
            case 3: {
                logger.info((Object)"HIERARCHY_LEVEL_HEADER");
                SpanCalc sc1 = this.spanCalc.createPositionHeader(new IgnorePropertiesHierarchyHeaderFactory());
                SpanCalc sc2 = this.spanCalc.createPositionHeader(new LevelHeaderFactory());
                this.headerSpans = SpanCalc.appendBelow(sc1, sc2);
                break;
            }
            case 2: {
                logger.info((Object)"LEVEL_HEADER");
                this.headerSpans = this.spanCalc.createPositionHeader(new LevelHeaderFactory());
                break;
            }
            case 1: {
                logger.info((Object)"HIERARCHY_HEADER");
                this.headerSpans = this.spanCalc.createPositionHeader(new HierarchyHeaderFactory());
                break;
            }
            default: {
                this.headerSpans = null;
            }
        }
        if (this.headerSpans != null) {
            this.headerSpans.setConfig(this.spanCalc.getConfig());
        }
    }

    @Override
    public void stopBuild() {
        super.stopBuild();
        this.headerSpans = null;
    }

    @Override
    protected Axis getAxis() {
        return this.table.getRowAxis();
    }
}

