/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator.member;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.navigator.member.MemberSelectionModel;
import com.tonbeller.jpivot.navigator.member.TreeModelAdapter;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.OlapUtils;
import com.tonbeller.jpivot.olap.navi.MemberDeleter;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import com.tonbeller.jpivot.ui.Available;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.changeorder.ChangeOrderModel;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.selection.SelectionModel;
import com.tonbeller.wcf.tree.CachingTreeModelDecorator;
import com.tonbeller.wcf.tree.DecoratedTreeModel;
import com.tonbeller.wcf.tree.DefaultDeleteNodeModel;
import com.tonbeller.wcf.tree.DefaultLabelProvider;
import com.tonbeller.wcf.tree.DefaultNodeRenderer;
import com.tonbeller.wcf.tree.DeleteNodeModel;
import com.tonbeller.wcf.tree.EnumBoundedTreeModelDecorator;
import com.tonbeller.wcf.tree.GroupingTreeModelDecorator;
import com.tonbeller.wcf.tree.LabelProvider;
import com.tonbeller.wcf.tree.MutableTreeModelDecorator;
import com.tonbeller.wcf.tree.NodeRenderer;
import com.tonbeller.wcf.tree.TreeBounding;
import com.tonbeller.wcf.tree.TreeComponent;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.ui.Button;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MemberNavigator
extends TreeComponent
implements ModelChangeListener,
Available {
    public static final String MEMBER_NAVIGATOR_LAZY_FETCH_CHILDREN = "MemberNavigator.lazyFetchChildren";
    public static final String MEMBER_NAVIGATOR_EXPAND_SELECTED = "MemberNavigator.expandSelected";
    public static final String MEMBER_NAVIGATOR_INITIAL_GROUPING = "MemberNavigator.initialGrouping";
    public static final String MEMBER_NAVIGATOR_GROUPING_MEMBER_COUNT = "MemberNavigator.groupingMemberCount";
    private OlapModel olapModel;
    private String title;
    private RequestListener okHandler;
    private RequestListener cancelHandler;
    private boolean showSelectNoneButton;
    private String okButtonId;
    private String cancelButtonId;
    private String selectVisibleButtonId;
    private String selectNoneButtonId;
    private String enableGroupingButtonId;
    private String disableGroupingButtonId;
    private Map models = new HashMap();
    private Resources resources;
    private int groupingMemberCount = 12;
    private boolean initialGrouping = true;
    private boolean expandSelected = true;
    private boolean lazyFetchChildren = false;
    private static Logger logger = Logger.getLogger(MemberNavigator.class);
    private DeleteNodeModel deleteModel = new DefaultDeleteNodeModel(){

        public boolean isDeletable(Object node) {
            if (MemberNavigator.this.olapModel == null) {
                return false;
            }
            MemberDeleter md = (MemberDeleter)MemberNavigator.this.olapModel.getExtension("memberDeleter");
            if (md == null) {
                return false;
            }
            if (node instanceof Member) {
                return md.isDeletable((Member)node);
            }
            return false;
        }
    };
    public static LabelProvider labelProvider = new DefaultLabelProvider(){

        public String getLabel(Object node) {
            if (node instanceof Displayable) {
                return ((Displayable)node).getLabel();
            }
            return super.getLabel(node);
        }
    };
    private TreeModelAdapter.OverflowListener overflowListener = new TreeModelAdapter.OverflowListener(){

        @Override
        public void overflowOccured() {
            MemberNavigator.this.setError(MemberNavigator.this.resources.getString("MemberNavigator.overflowOccurred"));
        }
    };

    public MemberNavigator(String id, Component parent, OlapModel olapModel, RequestListener okHandler, RequestListener cancelHandler) {
        super(id, parent);
        logger.info((Object)("creating instance: " + this));
        this.olapModel = olapModel;
        if (olapModel != null) {
            olapModel.addModelChangeListener(this);
        }
        this.okHandler = okHandler;
        this.cancelHandler = cancelHandler;
        this.setNodeRenderer((NodeRenderer)new DefaultNodeRenderer(labelProvider));
        if (id == null) {
            id = DomUtils.randomId();
        }
        this.okButtonId = id + ".ok";
        this.cancelButtonId = id + ".cancel";
        this.selectVisibleButtonId = id + ".selectVisible";
        this.selectNoneButtonId = id + ".selectNone";
        this.enableGroupingButtonId = id + ".enableGrouping";
        this.disableGroupingButtonId = id + ".disableGrouping";
        this.setSelectionModel((SelectionModel)new MemberSelectionModel());
        this.setDeleteNodeModel(this.deleteModel);
        this.setCutPasteMode(true);
    }

    public MemberNavigator(String id, Component parent, RequestListener okHandler, RequestListener cancelHandler) {
        this(id, parent, null, okHandler, cancelHandler);
    }

    public void setOlapModel(OlapModel newOlapModel) {
        if (this.olapModel != null) {
            this.olapModel.removeModelChangeListener(this);
        }
        this.olapModel = newOlapModel;
        if (this.olapModel != null) {
            this.olapModel.addModelChangeListener(this);
        }
        this.models.clear();
    }

    public String getTitle() {
        return this.title;
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        Dispatcher disp = super.getDispatcher();
        disp.addRequestListener(this.selectVisibleButtonId, null, (RequestListener)new SelectVisibleHandler());
        disp.addRequestListener(this.selectNoneButtonId, null, (RequestListener)new SelectNoneHandler());
        disp.addRequestListener(this.enableGroupingButtonId, null, (RequestListener)new SetGroupingHandler(true));
        disp.addRequestListener(this.disableGroupingButtonId, null, (RequestListener)new SetGroupingHandler(false));
        disp.addRequestListener(this.okButtonId, null, this.okHandler);
        disp.addRequestListener(this.cancelButtonId, null, this.cancelHandler);
        this.resources = context.getResources(MemberNavigator.class);
        this.groupingMemberCount = this.resources.getOptionalInteger(MEMBER_NAVIGATOR_GROUPING_MEMBER_COUNT, this.groupingMemberCount);
        this.initialGrouping = this.resources.getOptionalBoolean(MEMBER_NAVIGATOR_INITIAL_GROUPING, this.initialGrouping);
        this.expandSelected = this.resources.getOptionalBoolean(MEMBER_NAVIGATOR_EXPAND_SELECTED, this.expandSelected);
        this.lazyFetchChildren = this.resources.getOptionalBoolean(MEMBER_NAVIGATOR_LAZY_FETCH_CHILDREN, this.lazyFetchChildren);
        String s = context.getRequest().getParameter(MEMBER_NAVIGATOR_LAZY_FETCH_CHILDREN);
        if (s != null) {
            this.lazyFetchChildren = Boolean.valueOf(s);
        }
    }

    public Element render(RequestContext context, Document factory) throws Exception {
        if (this.getModel() == null) {
            throw new IllegalStateException("must call MemberNavigator.setHierarchy() before rendering");
        }
        Element elem = super.render(context, factory);
        elem.setAttribute("title", this.title);
        elem.setAttribute("closeId", this.cancelButtonId);
        this.renderButtons(elem, factory);
        this.setError(null);
        return elem;
    }

    private void renderButtons(Element parent, Document factory) {
        Element buttons = factory.createElement("buttons");
        parent.appendChild(buttons);
        this.appendSelectButton(buttons);
        this.appendGroupingButton(buttons);
        Button.addButton((Element)buttons, (String)this.okButtonId, (String)this.resources.getString("MemberNavigator.ok.title"));
        Button.addButton((Element)buttons, (String)this.cancelButtonId, (String)this.resources.getString("MemberNavigator.cancel.title"));
    }

    private void appendGroupingButton(Element buttons) {
        if (this.isGrouping()) {
            String label = this.resources.getString("MemberNavigator.disableGrouping.title");
            Button.addButton((Element)buttons, (String)this.disableGroupingButtonId, (String)label);
        } else {
            String label = this.resources.getString("MemberNavigator.enableGrouping.title");
            Button.addButton((Element)buttons, (String)this.enableGroupingButtonId, (String)label);
        }
    }

    private void appendSelectButton(Element buttons) {
        if (this.getSelectionModel().getMode() == 2) {
            if (this.getSelectionModel().isEmpty()) {
                String label = this.resources.getString("MemberNavigator.selectVisible.title");
                Button.addButton((Element)buttons, (String)this.selectVisibleButtonId, (String)label);
            } else {
                String label = this.resources.getString("MemberNavigator.selectNone.title");
                Button.addButton((Element)buttons, (String)this.selectNoneButtonId, (String)label);
            }
        } else if (this.showSelectNoneButton) {
            String label = this.resources.getString("MemberNavigator.selectNone.title");
            Button.addButton((Element)buttons, (String)this.selectNoneButtonId, (String)label);
        }
    }

    public void setHierarchies(Hierarchy[] hierarchies, boolean allowChangeOrder) {
        if (!this.isAvailable()) {
            return;
        }
        HierarchyArray hierarchyArray = new HierarchyArray(hierarchies);
        Object model = (TreeModel)this.models.get(hierarchyArray);
        if (model == null) {
            Locale locale = this.resources.getLocale();
            MemberTree memberTree = (MemberTree)this.olapModel.getExtension("memberTree");
            TreeModelAdapter modelAdapter = new TreeModelAdapter(hierarchies, memberTree, locale);
            modelAdapter.setOverflowListener(this.overflowListener);
            for (int i = 0; i < hierarchies.length; ++i) {
                if (!OlapUtils.isSingleRecord(hierarchies[i])) continue;
                Level[] levels = hierarchies[i].getLevels();
                modelAdapter.setNoChildrenLevel(levels[0]);
            }
            model = new CachingTreeModelDecorator((TreeModel)modelAdapter);
            if (this.lazyFetchChildren) {
                model = new EnumBoundedTreeModelDecorator(model);
            }
            if (hierarchies.length > 0 && !hierarchies[0].getDimension().isMeasure()) {
                model = new GroupingTreeModelDecorator(labelProvider, model, this.initialGrouping ? this.groupingMemberCount : 0);
            }
            model = new MutableMemberTreeModelDecorator((TreeModel)model);
            this.models.put(hierarchyArray, model);
        }
        super.setModel(model);
        MutableTreeModelDecorator mutableModel = (MutableTreeModelDecorator)this.findModel(MutableTreeModelDecorator.class);
        if (mutableModel != null) {
            mutableModel.setEnableChangeOrder(allowChangeOrder);
            super.setChangeOrderModel((ChangeOrderModel)mutableModel);
        }
        this.title = hierarchyArray.getLabel();
    }

    public void setHierarchies(Hierarchy[] hiers, boolean allowChangeOrder, MemberSelectionModel selection, Collection deleted) {
        this.setHierarchies(hiers, allowChangeOrder);
        if (this.lazyFetchChildren) {
            EnumBoundedTreeModelDecorator boundedModel = (EnumBoundedTreeModelDecorator)this.findModel(EnumBoundedTreeModelDecorator.class);
            boundedModel.setVisible((Collection)selection.getOrderedSelection());
            super.setBounding((TreeBounding)boundedModel);
        }
        this.setSelectionModel((SelectionModel)selection);
        if (this.expandSelected) {
            this.expandSelected(false);
        }
        Set set = this.getDeleteNodeModel().getDeleted();
        set.clear();
        set.addAll(deleted);
    }

    public void setHierarchy(Hierarchy hierarchy, boolean allowChangeOrder) {
        this.setHierarchies(new Hierarchy[]{hierarchy}, allowChangeOrder);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        for (TreeModel model : this.models.values()) {
            TreeModelAdapter tma = (TreeModelAdapter)this.findModel(model, TreeModelAdapter.class);
            tma.modelChanged();
        }
    }

    @Override
    public void structureChanged(ModelChangeEvent e) {
        logger.info((Object)"cleaning up");
        this.models.clear();
        super.setModel(null);
        super.getSelectionModel().clear();
    }

    public boolean isShowSelectNoneButton() {
        return this.showSelectNoneButton;
    }

    public void setShowSelectNoneButton(boolean b) {
        this.showSelectNoneButton = b;
    }

    public int getGroupingMemberCount() {
        return this.groupingMemberCount;
    }

    public void setGroupingMemberCount(int groupingMemberCount) {
        this.groupingMemberCount = groupingMemberCount;
    }

    public boolean isGrouping() {
        GroupingTreeModelDecorator groupingTreeModel = (GroupingTreeModelDecorator)this.findModel(GroupingTreeModelDecorator.class);
        if (groupingTreeModel != null) {
            return groupingTreeModel.getLimit() > 0;
        }
        return false;
    }

    public void setGrouping(boolean b) {
        GroupingTreeModelDecorator groupingTreeModel = (GroupingTreeModelDecorator)this.findModel(GroupingTreeModelDecorator.class);
        if (groupingTreeModel != null) {
            groupingTreeModel.setLimit(b ? this.groupingMemberCount : 0);
        }
    }

    private TreeModel findModel(Class clazz) {
        return this.findModel(this.getModel(), clazz);
    }

    private TreeModel findModel(TreeModel tm, Class clazz) {
        while (tm != null) {
            if (clazz.isAssignableFrom(tm.getClass())) {
                return tm;
            }
            if (!(tm instanceof DecoratedTreeModel)) {
                return null;
            }
            tm = ((DecoratedTreeModel)tm).getDecoree();
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return this.olapModel.getExtension("memberTree") != null;
    }

    public void setVisible(boolean b) {
        if (!this.isAvailable()) {
            b = false;
        }
        super.setVisible(b);
    }

    public boolean isExpandSelected() {
        return this.expandSelected;
    }

    public void setExpandSelected(boolean expandSelected) {
        this.expandSelected = expandSelected;
    }

    public boolean isLazyFetchChildren() {
        return this.lazyFetchChildren;
    }

    public void setLazyFetchChildren(boolean lazyFetchChildren) {
        this.lazyFetchChildren = lazyFetchChildren;
    }

    class MutableMemberTreeModelDecorator
    extends MutableTreeModelDecorator {
        public MutableMemberTreeModelDecorator(TreeModel decoree) {
            super(decoree);
        }

        public MutableMemberTreeModelDecorator(TreeModel decoree, Comparator comp) {
            super(decoree, comp);
        }

        public boolean mayMove(Object scope, Object node) {
            if (!(node instanceof Member)) {
                return false;
            }
            return super.mayMove(scope, node);
        }
    }

    class SetGroupingHandler
    implements RequestListener {
        boolean grouping;

        SetGroupingHandler(boolean grouping) {
            this.grouping = grouping;
        }

        public void request(RequestContext context) throws Exception {
            MemberNavigator.this.validate(context);
            MemberNavigator.this.setGrouping(this.grouping);
        }
    }

    class SelectNoneHandler
    implements RequestListener {
        SelectNoneHandler() {
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            MemberNavigator.this.validate(context);
            MemberNavigator.this.getSelectionModel().clear();
        }
    }

    class SelectVisibleHandler
    implements RequestListener {
        SelectVisibleHandler() {
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            MemberNavigator.this.validate(context);
            MemberNavigator.this.selectVisible();
        }
    }

    static class HierarchyArray {
        private Hierarchy[] hiers;

        public HierarchyArray(Hierarchy[] hiers) {
            this.hiers = hiers;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HierarchyArray)) {
                return false;
            }
            HierarchyArray that = (HierarchyArray)obj;
            if (this.hiers.length != that.hiers.length) {
                return false;
            }
            for (int i = 0; i < this.hiers.length; ++i) {
                if (this.hiers[i].equals(that.hiers[i])) continue;
                return false;
            }
            return true;
        }

        public Hierarchy[] getHierarchies() {
            return this.hiers;
        }

        public String getLabel() {
            if (this.hiers.length == 0) {
                return "";
            }
            if (this.hiers.length == 1) {
                return this.hiers[0].getLabel();
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.hiers.length; ++i) {
                if (i > 0) {
                    sb.append(" / ");
                }
                sb.append(this.hiers[i].getLabel());
            }
            return sb.toString();
        }

        public int hashCode() {
            int code = 27;
            for (int i = 0; i < this.hiers.length; ++i) {
                code ^= this.hiers[i].hashCode();
            }
            return code;
        }

        public void setHierarchies(Hierarchy[] hiers) {
            this.hiers = hiers;
        }
    }
}

