/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianCell;
import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.navi.DrillThrough;
import com.tonbeller.wcf.table.TableModel;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;

public class MondrianDrillThrough
extends ExtensionSupport
implements DrillThrough {
    private boolean extendedContext = true;

    public MondrianDrillThrough() {
        super.setId("drillThrough");
    }

    @Override
    public boolean canDrillThrough(Cell cell) {
        return ((MondrianCell)cell).getMonCell().canDrillThrough();
    }

    @Override
    public TableModel drillThrough(Cell cell) {
        String sql = ((MondrianCell)cell).getMonCell().getDrillThroughSQL(this.extendedContext);
        if (sql == null) {
            throw new NullPointerException("DrillThroughSQL returned null");
        }
        MondrianDrillThroughTableModel dtm = new MondrianDrillThroughTableModel();
        dtm.setSql(sql);
        Util.PropertyList connectInfo = ((MondrianModel)this.getModel()).getConnectProperties();
        String jdbcUrl = connectInfo.get(RolapConnectionProperties.Jdbc.name());
        String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
        String jdbcPassword = connectInfo.get(RolapConnectionProperties.JdbcPassword.name());
        String dataSourceName = connectInfo.get(RolapConnectionProperties.DataSource.name());
        dtm.setJdbcUrl(jdbcUrl);
        dtm.setJdbcUser(jdbcUser);
        dtm.setJdbcPassword(jdbcPassword);
        dtm.setDataSourceName(dataSourceName);
        dtm.setExternalDataSource(((MondrianModel)this.getModel()).getExternalDataSource());
        return dtm;
    }

    public boolean isExtendedContext() {
        return this.extendedContext;
    }

    public void setExtendedContext(boolean extendedContext) {
        this.extendedContext = extendedContext;
    }
}

