/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportGenerator;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ArrayClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ExtraShapesClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.URLClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DefaultDataSourceFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.elements.DefaultElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects.BandLayoutClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects.DefaultClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.DefaultStyleKeyFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.PageableLayoutStyleKeyFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.DefaultTemplateCollection;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ReportConverter {
    private static final Log logger = LogFactory.getLog(ReportConverter.class);

    public void write(MasterReport report, Writer w, URL contentBase, String encoding) throws IOException, ReportWriterException {
        if (contentBase == null) {
            throw new NullPointerException("ContentBase is null");
        }
        HierarchicalConfiguration config = new HierarchicalConfiguration((Configuration)report.getReportConfiguration());
        config.setConfigProperty("content-base", contentBase.toExternalForm());
        ReportWriter writer = new ReportWriter(report, encoding, (Configuration)config);
        writer.addClassFactoryFactory(new URLClassFactory());
        writer.addClassFactoryFactory(new DefaultClassFactory());
        writer.addClassFactoryFactory(new BandLayoutClassFactory());
        writer.addClassFactoryFactory(new ArrayClassFactory());
        writer.addClassFactoryFactory(new ExtraShapesClassFactory());
        writer.addStyleKeyFactory(new DefaultStyleKeyFactory());
        writer.addStyleKeyFactory(new PageableLayoutStyleKeyFactory());
        writer.addTemplateCollection(new DefaultTemplateCollection());
        writer.addElementFactory(new DefaultElementFactory());
        writer.addDataSourceFactory(new DefaultDataSourceFactory());
        writer.write(w);
    }

    public URL findReport(String name) throws IOException {
        URL in = ObjectUtilities.getResource((String)name, ReportConverter.class);
        if (in != null) {
            return in;
        }
        File f = new File(name);
        if (f.canRead()) {
            return f.toURL();
        }
        return null;
    }

    private MasterReport parseReport(URL templateURL) throws IOException {
        try {
            ReportGenerator generator = ReportGenerator.getInstance();
            return generator.parseReport(templateURL);
        }
        catch (Exception e) {
            logger.info((Object)"ParseReport failed; Cause: ", (Throwable)e);
            throw new IOException("Failed to parse the report");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertReport(String inName, String outFile, String encoding) throws IOException, ReportWriterException {
        URL reportURL = this.findReport(inName);
        if (reportURL == null) {
            throw new IOException("The specified report definition was not found");
        }
        File out = new File(outFile);
        FileOutputStream base = new FileOutputStream(out);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)base, encoding));
        try {
            this.convertReport(reportURL, out.toURL(), w, encoding);
        }
        finally {
            ((Writer)w).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertReport(File in, File out, String encoding) throws IOException, ReportWriterException {
        FileOutputStream base = new FileOutputStream(out);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)base, encoding));
        try {
            this.convertReport(in.toURL(), out.toURL(), w, encoding);
        }
        finally {
            ((Writer)w).close();
        }
    }

    public void convertReport(URL in, URL contentBase, Writer w, String encoding) throws IOException, ReportWriterException {
        if (in == null) {
            throw new NullPointerException("Input URL is null");
        }
        if (contentBase == null) {
            throw new NullPointerException("ContentBase is null");
        }
        if (w == null) {
            throw new NullPointerException("Writer is null");
        }
        if (encoding == null) {
            throw new NullPointerException("Encoding is null.");
        }
        MasterReport report = this.parseReport(in);
        this.write(report, w, contentBase, encoding);
        w.flush();
    }

    public static void main(String[] args) throws IOException, ReportWriterException {
        if (args.length != 2) {
            System.err.println("Usage: ReportConverter <InFile> <OutFile>");
            System.exit(1);
        }
        ReportConverter converter = new ReportConverter();
        converter.convertReport(args[0], args[1], "UTF-16");
    }
}

