/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.inlinedata;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.inlinedata.InlineTableDataReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InlineTableRowReadHandler
extends AbstractXmlReadHandler {
    private ArrayList data;
    private Class[] types;
    private int columnCount;

    public InlineTableRowReadHandler(Class[] types) {
        if (types == null) {
            throw new NullPointerException("Type-array must not be null.");
        }
        this.types = (Class[])types.clone();
        this.data = new ArrayList();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("data".equals(tagName)) {
            if (this.columnCount >= this.types.length) {
                return new IgnoreAnyChildReadHandler();
            }
            InlineTableDataReadHandler dataReadHandler = new InlineTableDataReadHandler(this.types[this.columnCount]);
            ++this.columnCount;
            this.data.add(dataReadHandler);
            return dataReadHandler;
        }
        return null;
    }

    public Object getObject() throws SAXException {
        Object[] result = new Object[this.types.length];
        int size = Math.min(this.data.size(), this.types.length);
        for (int i = 0; i < size; ++i) {
            InlineTableDataReadHandler handler = (InlineTableDataReadHandler)((Object)this.data.get(i));
            result[i] = handler.getObject();
        }
        return result;
    }
}

