/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandlerRegistry;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.StyleFileWriter;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;
import org.pentaho.reporting.engine.classic.core.util.NoCloseOutputStream;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StyleDefinitionWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, ElementStyleDefinition styleDefinition) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        try {
            this.write(bout, styleDefinition);
        }
        finally {
            bout.close();
        }
    }

    public void write(OutputStream outputStream, ElementStyleDefinition styleDefinition) throws IOException {
        DefaultTagDescription tagDescription = BundleWriterHandlerRegistry.getInstance().createWriterTagDescription();
        XmlWriter writer = new XmlWriter((Writer)new OutputStreamWriter((OutputStream)new NoCloseOutputStream(outputStream), "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        writer.writeXmlDeclaration("UTF-8");
        AttributeList rootAttributes = new AttributeList();
        rootAttributes.addNamespaceDeclaration("", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0");
        rootAttributes.addNamespaceDeclaration("layout", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0");
        rootAttributes.addNamespaceDeclaration("core", "http://reporting.pentaho.org/namespaces/engine/attributes/core");
        rootAttributes.addNamespaceDeclaration("html", "http://reporting.pentaho.org/namespaces/engine/attributes/html");
        rootAttributes.addNamespaceDeclaration("swing", "http://reporting.pentaho.org/namespaces/engine/attributes/swing");
        rootAttributes.addNamespaceDeclaration("pdf", "http://reporting.pentaho.org/namespaces/engine/attributes/pdf");
        rootAttributes.addNamespaceDeclaration("designtime", "http://reporting.pentaho.org/namespaces/report-designer/2.0");
        rootAttributes.addNamespaceDeclaration("crosstab", "http://reporting.pentaho.org/namespaces/engine/attributes/crosstab");
        rootAttributes.addNamespaceDeclaration("pentaho", "http://reporting.pentaho.org/namespaces/engine/attributes/pentaho");
        rootAttributes.addNamespaceDeclaration("table", "http://reporting.pentaho.org/namespaces/engine/attributes/table");
        rootAttributes.addNamespaceDeclaration("page", "http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext");
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "style-definition", rootAttributes, false);
        StyleFileWriter.writeStyleDefinition(writer, styleDefinition);
        writer.writeCloseTag();
        writer.flush();
        writer.close();
    }
}

