/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPageDefinition;
import org.pentaho.reporting.engine.classic.core.util.PageSize;

public final class ExcelPrintSetupFactory {
    public static final ExcelPageDefinition LETTER = new ExcelPageDefinition(1, PageSize.LETTER);
    public static final ExcelPageDefinition LETTER_SMALL = new ExcelPageDefinition(2, PageSize.LETTER_SMALL);
    public static final ExcelPageDefinition TABLOID = new ExcelPageDefinition(3, PageSize.TABLOID);
    public static final ExcelPageDefinition LEDGER = new ExcelPageDefinition(4, PageSize.LEDGER);
    public static final ExcelPageDefinition LEGAL = new ExcelPageDefinition(5, PageSize.LEGAL);
    public static final ExcelPageDefinition STATEMENT = new ExcelPageDefinition(6, PageSize.STATEMENT);
    public static final ExcelPageDefinition EXECUTIVE = new ExcelPageDefinition(7, PageSize.EXECUTIVE);
    public static final ExcelPageDefinition A3 = new ExcelPageDefinition(8, PageSize.A3);
    public static final ExcelPageDefinition A4 = new ExcelPageDefinition(9, PageSize.A4);
    public static final ExcelPageDefinition A4_SMALL = new ExcelPageDefinition(10, PageSize.A4_SMALL);
    public static final ExcelPageDefinition A5 = new ExcelPageDefinition(11, PageSize.A5);
    public static final ExcelPageDefinition B4 = new ExcelPageDefinition(12, PageSize.B4);
    public static final ExcelPageDefinition B5 = new ExcelPageDefinition(13, PageSize.B5);
    public static final ExcelPageDefinition FOLIO = new ExcelPageDefinition(14, PageSize.FOLIO);
    public static final ExcelPageDefinition QUARTO = new ExcelPageDefinition(15, PageSize.QUARTO);
    public static final ExcelPageDefinition PAPER10X14 = new ExcelPageDefinition(16, PageSize.PAPER10X14);
    public static final ExcelPageDefinition PAPER11X17 = new ExcelPageDefinition(17, PageSize.PAPER11X17);
    public static final ExcelPageDefinition NOTE = new ExcelPageDefinition(18, PageSize.NOTE);
    public static final ExcelPageDefinition ENV9 = new ExcelPageDefinition(19, PageSize.ENV9);
    public static final ExcelPageDefinition ENV10 = new ExcelPageDefinition(20, PageSize.ENV10);
    public static final ExcelPageDefinition ENV11 = new ExcelPageDefinition(21, PageSize.ENV11);
    public static final ExcelPageDefinition ENV12 = new ExcelPageDefinition(22, PageSize.ENV12);
    public static final ExcelPageDefinition ENV14 = new ExcelPageDefinition(23, PageSize.ENV14);
    public static final ExcelPageDefinition ENVDL = new ExcelPageDefinition(27, PageSize.ENVDL);
    public static final ExcelPageDefinition ENVC5 = new ExcelPageDefinition(28, PageSize.ENVC5);
    public static final ExcelPageDefinition ENVC3 = new ExcelPageDefinition(29, PageSize.ENVC3);
    public static final ExcelPageDefinition ENVC4 = new ExcelPageDefinition(30, PageSize.ENVC4);
    public static final ExcelPageDefinition ENVC6 = new ExcelPageDefinition(31, PageSize.ENVC6);
    public static final ExcelPageDefinition ENVC65 = new ExcelPageDefinition(32, PageSize.ENVC65);
    public static final ExcelPageDefinition ENVISOB4 = new ExcelPageDefinition(33, PageSize.ENVISOB4);
    public static final ExcelPageDefinition ENVB5 = new ExcelPageDefinition(34, PageSize.ENVISOB5);
    public static final ExcelPageDefinition ENVB6 = new ExcelPageDefinition(35, PageSize.ENVISOB6);
    public static final ExcelPageDefinition ENVELOPE = new ExcelPageDefinition(36, PageSize.ENVELOPE);
    public static final ExcelPageDefinition ENVMONARCH = new ExcelPageDefinition(37, PageSize.ENVMONARCH);
    public static final ExcelPageDefinition ENVPERSONAL = new ExcelPageDefinition(38, PageSize.ENVPERSONAL);
    public static final ExcelPageDefinition FANFOLDUS = new ExcelPageDefinition(39, PageSize.FANFOLDUS);
    public static final ExcelPageDefinition FANFOLDGERMAN = new ExcelPageDefinition(40, PageSize.FANFOLDGERMAN);
    public static final ExcelPageDefinition FANFOLDGERMANLEGAL = new ExcelPageDefinition(41, PageSize.FANFOLDGERMANLEGAL);

    private ExcelPrintSetupFactory() {
    }

    public static void performPageSetup(PrintSetup printSetup, PhysicalPageBox pageformat, String paperdef, String paperOrientation) {
        short pageCode = ExcelPrintSetupFactory.parsePaperSizeProperty(paperdef);
        if (pageCode == -1) {
            pageCode = ExcelPrintSetupFactory.computePaperSize(pageformat);
        }
        if (pageCode != -1) {
            printSetup.setPaperSize(pageCode);
        }
        if (paperOrientation != null && !paperOrientation.equals("auto")) {
            printSetup.setLandscape("Landscape".equalsIgnoreCase(paperOrientation));
        } else {
            boolean landscape = pageformat.getWidth() > pageformat.getHeight();
            printSetup.setLandscape(landscape);
        }
    }

    private static short computePaperSize(PhysicalPageBox format) {
        ExcelPageDefinition pageDef = null;
        int width = (int)format.getWidth();
        int height = (int)format.getHeight();
        int delta = -1;
        Field[] fields = ExcelPrintSetupFactory.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!ExcelPageDefinition.class.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                ExcelPageDefinition pageformat = (ExcelPageDefinition)field.get(null);
                if (pageformat.getWidth() < width || pageformat.getHeight() < height) continue;
                int newDelta = pageformat.getWidth() - width + (pageformat.getHeight() - height);
                if (delta != -1 && newDelta >= delta) continue;
                pageDef = pageformat;
                delta = newDelta;
                continue;
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        if (pageDef == null) {
            return -1;
        }
        return pageDef.getPageFormatCode();
    }

    private static short parsePaperSizeProperty(String paper) {
        if (paper == null) {
            return -1;
        }
        try {
            Field field = ExcelPrintSetupFactory.class.getDeclaredField(paper);
            if (!ExcelPageDefinition.class.isAssignableFrom(field.getType())) {
                return -1;
            }
            Object o = field.get(null);
            ExcelPageDefinition pageformat = (ExcelPageDefinition)o;
            return pageformat.getPageFormatCode();
        }
        catch (NoSuchFieldException nfe) {
            return -1;
        }
        catch (IllegalAccessException aie) {
            return -1;
        }
    }
}

