/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpec;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.DefaultTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper.RTFImageCache;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper.RTFOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.fonts.itext.BaseFontFontMetrics;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class RTFTextExtractor
extends DefaultTextExtractor {
    private RTFImageCache imageCache;
    private FastStack<StyleContext> context;
    private RTFOutputProcessorMetaData metaData;
    private boolean handleImages;

    public RTFTextExtractor(RTFOutputProcessorMetaData metaData) {
        super(metaData);
        this.metaData = metaData;
        this.handleImages = metaData.isFeatureSupported(RTFOutputProcessorMetaData.IMAGES_ENABLED);
        this.context = new FastStack(50);
    }

    private StyleContext getCurrentContext() {
        return (StyleContext)this.context.peek();
    }

    public void compute(RenderBox box, TextElementArray cell, RTFImageCache imageCache) {
        this.context.clear();
        this.context.push((Object)new StyleContext(cell, box.getStyleSheet(), this.metaData));
        this.imageCache = imageCache;
        super.compute(box);
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        StyleContext boxContext;
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        StyleContext currentContext = this.getCurrentContext();
        if (!currentContext.equals(boxContext = new StyleContext(currentContext.getTarget(), box.getStyleSheet(), this.metaData))) {
            if (this.getTextLength() > 0) {
                String text = this.getText();
                currentContext.add(text);
                this.clearText();
            }
            this.context.pop();
            this.context.push((Object)boxContext);
        }
        return true;
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        StyleContext currentContext = this.getCurrentContext();
        if (this.getTextLength() > 0) {
            String text = this.getText();
            currentContext.add(text);
            this.clearText();
        }
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        StrictBounds paragraphBounds = this.getParagraphBounds();
        if (this.isTextLineOverflow() && !node.isNodeVisible(paragraphBounds, this.isOverflowX(), this.isOverflowY())) {
            return;
        }
        super.processOtherNode(node);
        if (node.getNodeType() == 17) {
            if (node.isVirtualNode()) {
                return;
            }
            if (node.getX() + node.getWidth() > paragraphBounds.getX() + paragraphBounds.getWidth()) {
                return;
            }
            RenderableText text = (RenderableText)node;
            if (text.isForceLinebreak()) {
                StyleContext currentContext = this.getCurrentContext();
                if (this.getTextLength() > 0) {
                    currentContext.add(this.getText());
                    this.clearText();
                }
                this.context.pop();
                StyleContext cellContext = this.getCurrentContext();
                cellContext.add((Element)currentContext.getTarget());
                this.context.push((Object)new StyleContext((TextElementArray)new Paragraph(), text.getStyleSheet(), this.metaData));
            }
        } else if (node.getNodeType() == 273) {
            if (node.isVirtualNode()) {
                return;
            }
            if (node.getX() + node.getWidth() > paragraphBounds.getX() + paragraphBounds.getWidth()) {
                return;
            }
            RenderableComplexText text = (RenderableComplexText)node;
            if (text.isForceLinebreak()) {
                StyleContext currentContext = this.getCurrentContext();
                if (this.getTextLength() > 0) {
                    currentContext.add(this.getText());
                    this.clearText();
                }
                this.context.pop();
                StyleContext cellContext = this.getCurrentContext();
                cellContext.add((Element)currentContext.getTarget());
                this.context.push((Object)new StyleContext((TextElementArray)new Paragraph(), text.getStyleSheet(), this.metaData));
            }
        }
    }

    @Override
    protected void processRenderableContent(RenderableReplacedContentBox node) {
        try {
            RenderableReplacedContent rpc = node.getContent();
            Object rawObject = rpc.getRawObject();
            if (rawObject instanceof ImageContainer) {
                Image image = this.imageCache.getImage((ImageContainer)rawObject);
                if (image == null) {
                    return;
                }
                StyleContext currentContext = this.getCurrentContext();
                if (this.getTextLength() > 0) {
                    currentContext.add(this.getText());
                    this.clearText();
                }
                currentContext.add((Element)image);
            } else if (rawObject instanceof DrawableWrapper) {
                StrictBounds rect = new StrictBounds(node.getX(), node.getY(), node.getWidth(), node.getHeight());
                ImageContainer ic = RenderUtility.createImageFromDrawable((DrawableWrapper)rawObject, rect, node, (OutputProcessorMetaData)this.metaData);
                if (ic == null) {
                    return;
                }
                Image image = this.imageCache.getImage(ic);
                if (image == null) {
                    return;
                }
                StyleContext currentContext = this.getCurrentContext();
                if (this.getTextLength() > 0) {
                    currentContext.add(this.getText());
                    this.clearText();
                }
                currentContext.add((Element)image);
            }
        }
        catch (DocumentException ioe) {
            throw new InvalidReportStateException("Failed to extract text", ioe);
        }
        catch (IOException e) {
            throw new InvalidReportStateException("Failed to extract text", e);
        }
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.context.push((Object)new StyleContext((TextElementArray)new Paragraph(), box.getStyleSheet(), this.metaData));
        this.clearText();
        super.processParagraphChilds(box);
        StyleContext currentContext = this.getCurrentContext();
        if (this.getTextLength() > 0) {
            currentContext.add(this.getText());
            this.clearText();
        }
        this.context.pop();
        this.getCurrentContext().add((Element)currentContext.getTarget());
    }

    @Override
    protected void drawComplexText(RenderableComplexText renderableComplexText) {
        if (renderableComplexText.getRawText().length() == 0) {
            return;
        }
        if (!renderableComplexText.isNodeVisible(this.getParagraphBounds(), this.isOverflowX(), this.isOverflowY())) {
            return;
        }
        if (renderableComplexText.getRichText().getStyleChunks().size() > 1) {
            for (RichTextSpec.StyledChunk styledChunk : renderableComplexText.getRichText().getStyleChunks()) {
                StyleContext boxContext = new StyleContext(this.getCurrentContext().getTarget(), styledChunk.getStyleSheet(), this.metaData);
                if (styledChunk.getText().length() > 0) {
                    String text = styledChunk.getText();
                    boxContext.add(text);
                    this.clearText();
                }
                this.context.pop();
                this.context.push((Object)boxContext);
            }
        } else {
            super.drawComplexText(renderableComplexText);
        }
    }

    private static class StyleContext {
        private TextElementArray target;
        private RTFOutputProcessorMetaData metaData;
        private String fontName;
        private double fontSize;
        private boolean bold;
        private boolean italic;
        private boolean underline;
        private boolean strikethrough;
        private Color textColor;
        private Color backgroundColor;

        protected StyleContext(TextElementArray target, StyleSheet styleSheet, RTFOutputProcessorMetaData metaData) {
            this.target = target;
            this.metaData = metaData;
            this.fontName = (String)styleSheet.getStyleProperty(TextStyleKeys.FONT);
            this.fontSize = styleSheet.getDoubleStyleProperty(TextStyleKeys.FONTSIZE, 0.0);
            this.bold = styleSheet.getBooleanStyleProperty(TextStyleKeys.BOLD);
            this.italic = styleSheet.getBooleanStyleProperty(TextStyleKeys.ITALIC);
            this.underline = styleSheet.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
            this.strikethrough = styleSheet.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
            this.textColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.PAINT);
            this.backgroundColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
        }

        public TextElementArray getTarget() {
            return this.target;
        }

        public String getFontName() {
            return this.fontName;
        }

        public double getFontSize() {
            return this.fontSize;
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public boolean isUnderline() {
            return this.underline;
        }

        public boolean isStrikethrough() {
            return this.strikethrough;
        }

        public Color getTextColor() {
            return this.textColor;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public void add(Element element) {
            this.target.add((Object)element);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StyleContext that = (StyleContext)o;
            if (this.bold != that.bold) {
                return false;
            }
            if (that.fontSize != this.fontSize) {
                return false;
            }
            if (this.italic != that.italic) {
                return false;
            }
            if (this.strikethrough != that.strikethrough) {
                return false;
            }
            if (this.underline != that.underline) {
                return false;
            }
            if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) {
                return false;
            }
            if (this.fontName != null ? !this.fontName.equals(that.fontName) : that.fontName != null) {
                return false;
            }
            return !(this.textColor != null ? !this.textColor.equals(that.textColor) : that.textColor != null);
        }

        public int hashCode() {
            int result = this.fontName != null ? this.fontName.hashCode() : 0;
            long temp = this.fontSize != 0.0 ? Double.doubleToLongBits(this.fontSize) : 0L;
            result = 29 * result + (int)(temp ^ temp >>> 32);
            result = 29 * result + (this.bold ? 1 : 0);
            result = 29 * result + (this.italic ? 1 : 0);
            result = 29 * result + (this.underline ? 1 : 0);
            result = 29 * result + (this.strikethrough ? 1 : 0);
            result = 29 * result + (this.textColor != null ? this.textColor.hashCode() : 0);
            result = 29 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
            return result;
        }

        public void add(String text) {
            int style = 0;
            if (this.bold) {
                style |= 1;
            }
            if (this.italic) {
                style |= 2;
            }
            if (this.strikethrough) {
                style |= 8;
            }
            if (this.underline) {
                style |= 4;
            }
            BaseFontFontMetrics fontMetrics = this.metaData.getBaseFontFontMetrics(this.fontName, this.fontSize, this.bold, this.italic, "utf-8", false, false);
            BaseFont baseFont = fontMetrics.getBaseFont();
            Font font = new Font(baseFont, (float)this.fontSize, style, this.textColor);
            Chunk c = new Chunk(text, font);
            if (this.backgroundColor != null) {
                c.setBackground(this.backgroundColor);
            }
            this.target.add((Object)c);
        }
    }
}

