/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.pentaho.reporting.libraries.base.util.MemoryStringWriter;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class WriterService {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private MemoryStringWriter bufferWriter;
    private BufferedWriter writer;
    private XmlWriter xmlWriter;

    private WriterService(BufferedWriter bufferedWriter) {
        this.writer = bufferedWriter;
    }

    public WriterService(BufferedWriter bufferedWriter, MemoryStringWriter bufferWriter) {
        this.writer = bufferedWriter;
        this.bufferWriter = bufferWriter;
    }

    public XmlWriter getXmlWriter() {
        return this.xmlWriter;
    }

    public MemoryStringWriter getBufferWriter() {
        return this.bufferWriter;
    }

    public XmlWriter createHeaderXmlWriter() {
        if (!this.isBuffered()) {
            throw new IllegalStateException();
        }
        XmlWriter docWriter = new XmlWriter((Writer)this.writer, this.xmlWriter.getTagDescription());
        docWriter.addImpliedNamespace(XHTML_NAMESPACE, "");
        docWriter.setHtmlCompatiblityMode(true);
        return docWriter;
    }

    private void setXmlWriter(XmlWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
    }

    private static DefaultTagDescription createTagDefinitions() {
        DefaultTagDescription td = new DefaultTagDescription();
        td.setDefaultNamespace(XHTML_NAMESPACE);
        td.setNamespaceHasCData(XHTML_NAMESPACE, true);
        td.setNamespaceHasCData(XHTML_NAMESPACE, true);
        td.setElementHasCData(XHTML_NAMESPACE, "body", false);
        td.setElementHasCData(XHTML_NAMESPACE, "br", true);
        td.setElementHasCData(XHTML_NAMESPACE, "col", false);
        td.setElementHasCData(XHTML_NAMESPACE, "colgroup", false);
        td.setElementHasCData(XHTML_NAMESPACE, "div", true);
        td.setElementHasCData(XHTML_NAMESPACE, "head", false);
        td.setElementHasCData(XHTML_NAMESPACE, "html", false);
        td.setElementHasCData(XHTML_NAMESPACE, "img", true);
        td.setElementHasCData(XHTML_NAMESPACE, "input", true);
        td.setElementHasCData(XHTML_NAMESPACE, "meta", true);
        td.setElementHasCData(XHTML_NAMESPACE, "p", true);
        td.setElementHasCData(XHTML_NAMESPACE, "pre", true);
        td.setElementHasCData(XHTML_NAMESPACE, "span", true);
        td.setElementHasCData(XHTML_NAMESPACE, "style", false);
        td.setElementHasCData(XHTML_NAMESPACE, "table", false);
        td.setElementHasCData(XHTML_NAMESPACE, "tbody", false);
        td.setElementHasCData(XHTML_NAMESPACE, "td", true);
        td.setElementHasCData(XHTML_NAMESPACE, "tfoot", false);
        td.setElementHasCData(XHTML_NAMESPACE, "th", false);
        td.setElementHasCData(XHTML_NAMESPACE, "thead", false);
        td.setElementHasCData(XHTML_NAMESPACE, "title", true);
        td.setElementHasCData(XHTML_NAMESPACE, "tr", false);
        return td;
    }

    public boolean isBuffered() {
        return this.bufferWriter != null;
    }

    public static WriterService createPassThroughService(OutputStream out, String encoding) throws UnsupportedEncodingException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(out, encoding));
        XmlWriter xmlWriter = new XmlWriter((Writer)bufferedWriter, (TagDescription)WriterService.createTagDefinitions());
        xmlWriter.addImpliedNamespace(XHTML_NAMESPACE, "");
        xmlWriter.setHtmlCompatiblityMode(true);
        WriterService writerService = new WriterService(bufferedWriter);
        writerService.setXmlWriter(xmlWriter);
        return writerService;
    }

    public static WriterService createBufferedService(OutputStream out, String encoding) throws UnsupportedEncodingException {
        MemoryStringWriter bufferWriter = new MemoryStringWriter(524288);
        XmlWriter xmlWriter = new XmlWriter((Writer)bufferWriter, (TagDescription)WriterService.createTagDefinitions());
        xmlWriter.setAdditionalIndent(1);
        xmlWriter.addImpliedNamespace(XHTML_NAMESPACE, "");
        xmlWriter.setHtmlCompatiblityMode(true);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(out, encoding));
        WriterService writerService = new WriterService(bufferedWriter, bufferWriter);
        writerService.setXmlWriter(xmlWriter);
        return writerService;
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

