/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.AbstractPageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.AllPageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.PlainTextReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.TextDocumentWriter;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.TextOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class PageableTextOutputProcessor
extends AbstractPageableOutputProcessor {
    private TextDocumentWriter writer;
    private OutputProcessorMetaData metaData;
    private PrinterDriver driver;
    private PageFlowSelector flowSelector;
    private String encoding;

    public PageableTextOutputProcessor(PrinterDriver driver, Configuration configuration) {
        if (driver == null) {
            throw new NullPointerException();
        }
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.driver = driver;
        this.metaData = new TextOutputProcessorMetaData(driver.getLinesPerInch(), driver.getCharactersPerInch());
        this.flowSelector = new AllPageFlowSelector();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public PageFlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public void setFlowSelector(PageFlowSelector flowSelector) {
        if (flowSelector == null) {
            throw new NullPointerException();
        }
        this.flowSelector = flowSelector;
    }

    @Override
    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        if (this.writer != null) {
            this.metaData.commit();
            this.writer.close();
        }
    }

    @Override
    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) throws ContentProcessingException {
        try {
            if (this.writer == null) {
                if (this.encoding == null) {
                    String encoding = this.metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
                    this.writer = new TextDocumentWriter(this.metaData, this.driver, encoding);
                } else {
                    this.writer = new TextDocumentWriter(this.metaData, this.driver, this.encoding);
                }
                this.writer.open();
                byte[] sequence = PlainTextReportUtil.getInitSequence(this.metaData.getConfiguration());
                if (sequence != null) {
                    this.driver.printRaw(sequence);
                }
            }
            this.writer.processPhysicalPage(pageGrid, logicalPage, row, col, pageKey);
        }
        catch (Exception e) {
            throw new ContentProcessingException("Failed to generate the PlainText document", e);
        }
    }

    @Override
    protected void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) throws ContentProcessingException {
        try {
            if (this.writer == null) {
                if (this.encoding == null) {
                    String encoding = this.metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
                    this.writer = new TextDocumentWriter(this.metaData, this.driver, encoding);
                } else {
                    this.writer = new TextDocumentWriter(this.metaData, this.driver, this.encoding);
                }
                this.writer.open();
            }
            this.writer.processLogicalPage(key, logicalPage);
        }
        catch (Exception e) {
            throw new ContentProcessingException("Failed to generate the PlainText document", e);
        }
    }
}

