/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.xls;

import org.apache.poi.ss.usermodel.CellStyle;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.CellStyleProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelFontFactory;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.LFUMap;

public class FastExcelCellStyleProducer
implements CellStyleProducer {
    private CellStyleProducer backend;
    private LFUMap<CellBackground, CellStyle> backgroundCache;
    private LFUMap<CacheKey, CellStyle> contentCache;

    public FastExcelCellStyleProducer(CellStyleProducer backend) {
        if (backend == null) {
            throw new NullPointerException();
        }
        this.contentCache = new LFUMap(5000);
        this.backgroundCache = new LFUMap(5000);
        this.backend = backend;
    }

    @Override
    public CellStyle createCellStyle(InstanceID id, StyleSheet element, CellBackground bg) {
        CellStyle cellStyle;
        if (id == null ? (cellStyle = (CellStyle)this.backgroundCache.get((Object)bg)) != null : (cellStyle = (CellStyle)this.contentCache.get((Object)new CacheKey(id, bg))) != null) {
            return cellStyle;
        }
        cellStyle = this.backend.createCellStyle(id, element, bg);
        if (cellStyle == null) {
            return null;
        }
        if (id == null) {
            this.backgroundCache.put((Object)bg, (Object)cellStyle);
        } else {
            this.contentCache.put((Object)new CacheKey(id, bg), (Object)cellStyle);
        }
        return cellStyle;
    }

    @Override
    public ExcelFontFactory getFontFactory() {
        return this.backend.getFontFactory();
    }

    private static class CacheKey {
        private InstanceID id;
        private CellBackground background;

        private CacheKey(InstanceID id, CellBackground background) {
            this.id = id;
            this.background = background;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.background != null ? !this.background.equals(cacheKey.background) : cacheKey.background != null) {
                return false;
            }
            return !(this.id != null ? !this.id.equals(cacheKey.id) : cacheKey.id != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.background != null ? this.background.hashCode() : 0);
            return result;
        }
    }
}

