/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class TypeMapper {
    private static final Log logger = LogFactory.getLog(TypeMapper.class);
    private static final Class byteArrayClass = byte[].class;

    private static Class mapSQLType(int t) {
        switch (t) {
            case 2003: {
                return Object[].class;
            }
            case -5: {
                return Long.class;
            }
            case -2: {
                return byteArrayClass;
            }
            case -7: {
                return Boolean.class;
            }
            case 2004: {
                return Blob.class;
            }
            case 16: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 70: {
                return URL.class;
            }
            case 91: {
                return Date.class;
            }
            case 3: {
                return BigDecimal.class;
            }
            case 2001: {
                return Object.class;
            }
            case 8: {
                return Double.class;
            }
            case 6: {
                return Double.class;
            }
            case 4: {
                return Integer.class;
            }
            case 2000: {
                return Object.class;
            }
            case -4: {
                return byteArrayClass;
            }
            case -1: {
                return String.class;
            }
            case 2011: {
                return NClob.class;
            }
            case 0: {
                return Object.class;
            }
            case 2: {
                return BigDecimal.class;
            }
            case -16: 
            case -15: 
            case -9: {
                return String.class;
            }
            case 1111: {
                return Object.class;
            }
            case 7: {
                return Float.class;
            }
            case 2006: {
                return Ref.class;
            }
            case -8: {
                return RowId.class;
            }
            case 5: {
                return Short.class;
            }
            case 2002: {
                return Struct.class;
            }
            case 2009: {
                return SQLXML.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -6: {
                return Byte.class;
            }
            case -3: {
                return byteArrayClass;
            }
            case 12: {
                return String.class;
            }
        }
        return Object.class;
    }

    public static Class[] mapTypes(ResultSetMetaData rsmd) {
        Class[] types;
        try {
            types = new Class[rsmd.getColumnCount()];
        }
        catch (SQLException sqle) {
            return null;
        }
        ClassLoader cl = ObjectUtilities.getClassLoader(TypeMapper.class);
        int typeLength = types.length;
        for (int i = 0; i < typeLength; ++i) {
            block8: {
                try {
                    int colType;
                    try {
                        String tn = rsmd.getColumnClassName(i + 1);
                        if (tn == null) {
                            colType = rsmd.getColumnType(i + 1);
                            types[i] = TypeMapper.mapSQLType(colType);
                            break block8;
                        }
                        types[i] = Class.forName(tn, false, cl);
                    }
                    catch (Exception oops) {
                        colType = rsmd.getColumnType(i + 1);
                        types[i] = TypeMapper.mapSQLType(colType);
                    }
                }
                catch (Exception e) {
                    types[i] = Object.class;
                }
            }
            if (types[i] != null) continue;
            logger.error((Object)"JDBC Driver returned <null> as column type. This driver violates the JDBC specifications.");
            types[i] = Object.class;
        }
        return types;
    }

    private TypeMapper() {
    }
}

