/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.xls;

import java.awt.Window;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.xls.ExcelExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.xls.ExcelExportTask;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ExcelExportPlugin
extends AbstractExportActionPlugin {
    private final ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.xls.messages.messages", ObjectUtilities.getClassLoader(ExcelExportPlugin.class));
    public static final String BASE_RESOURCE_CLASS = "org.pentaho.reporting.engine.classic.core.modules.gui.xls.messages.messages";

    @Override
    public boolean initialize(SwingGuiContext context) {
        if (!super.initialize(context)) {
            return false;
        }
        return ClassicEngineBoot.getInstance().isModuleAvailable(ExcelExportGUIModule.class.getName());
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.xls.export.xls.";
    }

    @Override
    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setMessage(this.resources.getString("excel-export.progressdialog.message"));
        progressDialog.pack();
        LibSwingUtil.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    @Override
    public boolean performExport(MasterReport report) {
        ReportProgressDialog progressDialog;
        boolean result = this.performShowExportDialog(report, "org.pentaho.reporting.engine.classic.core.modules.gui.xls.Dialog");
        if (!result) {
            return false;
        }
        if (this.isProgressDialogEnabled(report, "org.pentaho.reporting.engine.classic.core.modules.gui.xls.ProgressDialogEnabled")) {
            progressDialog = this.createProgressDialog();
            if (report.getTitle() == null) {
                progressDialog.setTitle(this.getResources().getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                progressDialog.setTitle(this.getResources().formatMessage("ProgressDialog.TITLE", (Object)report.getTitle()));
            }
        } else {
            progressDialog = null;
        }
        try {
            ExcelExportTask task = new ExcelExportTask(report, progressDialog, this.getContext());
            Thread worker = new Thread(task);
            worker.start();
            return true;
        }
        catch (Exception e) {
            this.getContext().getStatusListener().setStatus(StatusType.ERROR, this.resources.getString("ExcelExportPlugin.USER_FAILED"), e);
            return false;
        }
    }

    @Override
    public String getShortDescription() {
        return this.resources.getString("action.export-to-excel.description");
    }

    @Override
    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.export-to-excel.small-icon");
    }

    @Override
    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.export-to-excel.icon");
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.export-to-excel.accelerator");
    }

    @Override
    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.export-to-excel.mnemonic");
    }

    @Override
    public String getDisplayName() {
        return this.resources.getString("action.export-to-excel.name");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }
}

