/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultReportPreProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ReportPreProcessorPropertyReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportPreProcessorReadHandler
extends AbstractMetaDataReadHandler {
    private Class expressionClass;
    private ArrayList<ReportPreProcessorPropertyReadHandler> attributeHandlers = new ArrayList();
    private SharedBeanInfo beanInfo;
    private HashMap<String, ReportPreProcessorPropertyMetaData> properties = new HashMap();
    private boolean autoProcess;
    private boolean executeInDesignMode;
    private int executionPriority;

    @Override
    protected boolean isDerivedName() {
        return true;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.autoProcess = "true".equals(attrs.getValue(this.getUri(), "auto-process"));
        this.executionPriority = ParserUtil.parseInt((String)attrs.getValue(this.getUri(), "priority"), (int)0);
        this.executeInDesignMode = "true".equals(attrs.getValue(this.getUri(), "execute-in-design-mode"));
        String valueTypeText = attrs.getValue(this.getUri(), "class");
        if (valueTypeText == null) {
            throw new ParseException("Attribute 'class' is undefined", this.getLocator());
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ReportPreProcessorReadHandler.class);
            this.expressionClass = Class.forName(valueTypeText, false, loader);
            if (!ReportPreProcessor.class.isAssignableFrom(this.expressionClass)) {
                throw new ParseException("Attribute 'class' is not valid", this.getLocator());
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'class' is not valid", e, this.getLocator());
        }
        this.beanInfo = new SharedBeanInfo(this.expressionClass);
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("property".equals(tagName)) {
            ReportPreProcessorPropertyReadHandler readHandler = new ReportPreProcessorPropertyReadHandler(this.beanInfo, this.getBundle());
            this.attributeHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.attributeHandlers.size(); ++i) {
            ReportPreProcessorPropertyReadHandler handler = this.attributeHandlers.get(i);
            String attrName = handler.getName();
            this.properties.put(attrName, handler.getObject());
        }
    }

    public Object getObject() throws SAXException {
        return new DefaultReportPreProcessorMetaData(this.getBundle(), this.isExpert(), this.isPreferred(), this.isHidden(), this.isDeprecated(), this.expressionClass, this.properties, this.beanInfo, this.autoProcess, this.executeInDesignMode, this.isExperimental(), this.getCompatibilityLevel(), this.executionPriority);
    }
}

