/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultReportPreProcessorPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultReportPreProcessorPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportPreProcessorPropertyReadHandler
extends AbstractXmlReadHandler {
    private boolean validatePropertiesOnBoot = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.StrictValidation"));
    private String name;
    private boolean preferred;
    private boolean mandatory;
    private boolean expert;
    private boolean hidden;
    private String valueRole;
    private boolean deprecated;
    private SharedBeanInfo expression;
    private String bundleLocation;
    private String propertyEditorClass;
    private boolean computed;
    private ReportPreProcessorPropertyCore reportPreProcessorPropertyCore;
    private boolean experimental;
    private int compatibilityLevel;

    public ReportPreProcessorPropertyReadHandler(SharedBeanInfo expression, String bundleLocation) {
        this.expression = expression;
        this.bundleLocation = bundleLocation;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Attribute 'name' is undefined", this.getLocator());
        }
        this.mandatory = "true".equals(attrs.getValue(this.getUri(), "mandatory"));
        this.expert = "true".equals(attrs.getValue(this.getUri(), "expert"));
        this.hidden = "true".equals(attrs.getValue(this.getUri(), "hidden"));
        this.preferred = "true".equals(attrs.getValue(this.getUri(), "preferred"));
        this.deprecated = "true".equals(attrs.getValue(this.getUri(), "deprecated"));
        this.computed = "true".equals(attrs.getValue(this.getUri(), "computed"));
        this.experimental = "true".equals(attrs.getValue(this.getUri(), "experimental"));
        this.compatibilityLevel = ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibility-level"));
        this.valueRole = attrs.getValue(this.getUri(), "value-role");
        if (this.valueRole == null) {
            this.valueRole = "Value";
        }
        this.propertyEditorClass = attrs.getValue(this.getUri(), "propertyEditor");
        if (this.validatePropertiesOnBoot && this.expression.getPropertyDescriptor(this.name) == null) {
            throw new ParseException("Attribute 'name' with value '" + this.name + "' does not reference a valid property. [" + this.expression + "]", this.getLocator());
        }
        String metaDataCoreClass = attrs.getValue(this.getUri(), "impl");
        if (metaDataCoreClass != null) {
            this.reportPreProcessorPropertyCore = (ReportPreProcessorPropertyCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, ReportPreProcessorPropertyReadHandler.class, ReportPreProcessorPropertyCore.class);
            if (this.reportPreProcessorPropertyCore == null) {
                throw new ParseException("Attribute 'impl' references a invalid ReportPreProcessorPropertyCore implementation.", this.getLocator());
            }
        } else {
            this.reportPreProcessorPropertyCore = new DefaultReportPreProcessorPropertyCore();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getValueRole() {
        return this.valueRole;
    }

    public ReportPreProcessorPropertyMetaData getObject() throws SAXException {
        return new DefaultReportPreProcessorPropertyMetaData(this.name, this.bundleLocation, this.expert, this.preferred, this.hidden, this.deprecated, this.mandatory, this.computed, this.valueRole, this.expression, this.propertyEditorClass, this.reportPreProcessorPropertyCore, this.experimental, this.compatibilityLevel);
    }
}

