/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ExpressionPropertyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExpressionReadHandler
extends AbstractXmlReadHandler {
    private String bundleName;
    private Class expressionClass;
    private Class resultType;
    private boolean expert;
    private boolean hidden;
    private boolean preferred;
    private boolean deprecated;
    private ArrayList<ExpressionPropertyReadHandler> attributeHandlers = new ArrayList();
    private SharedBeanInfo beanInfo;
    private HashMap<String, ExpressionPropertyMetaData> properties = new HashMap();
    private int layoutComputation;
    private boolean experimental;
    private int compatibilityLevel;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.bundleName = attrs.getValue(this.getUri(), "bundle-name");
        this.expert = "true".equals(attrs.getValue(this.getUri(), "expert"));
        this.hidden = "true".equals(attrs.getValue(this.getUri(), "hidden"));
        this.preferred = "true".equals(attrs.getValue(this.getUri(), "preferred"));
        this.deprecated = "true".equals(attrs.getValue(this.getUri(), "deprecated"));
        this.experimental = "true".equals(attrs.getValue(this.getUri(), "experimental"));
        this.compatibilityLevel = ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibility-level"));
        String layoutProcessorMode = attrs.getValue(this.getUri(), "layout-processor-mode");
        this.layoutComputation = "global".equals(layoutProcessorMode) ? 2 : ("element".equals(layoutProcessorMode) ? 1 : 0);
        String valueTypeText = attrs.getValue(this.getUri(), "class");
        if (valueTypeText == null) {
            throw new ParseException("Attribute 'class' is undefined", this.getLocator());
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ExpressionReadHandler.class);
            this.expressionClass = Class.forName(valueTypeText, false, loader);
            if (!Expression.class.isAssignableFrom(this.expressionClass)) {
                throw new ParseException("Attribute 'class' is not valid", this.getLocator());
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'class' is not valid", e, this.getLocator());
        }
        this.beanInfo = new SharedBeanInfo(this.expressionClass);
        String resultType = attrs.getValue(this.getUri(), "result");
        if (resultType == null) {
            throw new ParseException("Attribute 'result' is undefined", this.getLocator());
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ExpressionReadHandler.class);
            this.resultType = Class.forName(resultType, false, loader);
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'result' is not valid", e, this.getLocator());
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("property".equals(tagName)) {
            ExpressionPropertyReadHandler readHandler = new ExpressionPropertyReadHandler(this.beanInfo, this.bundleName);
            this.attributeHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.attributeHandlers.size(); ++i) {
            ExpressionPropertyReadHandler handler = this.attributeHandlers.get(i);
            String attrName = handler.getName();
            this.properties.put(attrName, handler.getObject());
        }
    }

    public Object getObject() throws SAXException {
        return new DefaultExpressionMetaData(this.bundleName, this.expert, this.preferred, this.hidden, this.deprecated, this.expressionClass, this.resultType, this.properties, this.beanInfo, this.layoutComputation, this.experimental, this.compatibilityLevel);
    }
}

