/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataFactoryReadHandler
extends AbstractMetaDataReadHandler {
    private String bundleName;
    private boolean editable;
    private boolean freeformQuery;
    private boolean formattingMetadataSource;
    private DataFactoryCore dataFactoryCore;
    private int compatibilityLevel;
    private String keyPrefix;

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        String editable;
        super.startParsing(attrs);
        this.compatibilityLevel = ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibility-level"));
        this.keyPrefix = attrs.getValue(this.getUri(), "key-prefix");
        if (this.keyPrefix == null) {
            this.keyPrefix = "";
        }
        this.editable = (editable = attrs.getValue(this.getUri(), "editable")) == null || "true".equals(editable);
        this.freeformQuery = "true".equals(attrs.getValue(this.getUri(), "freeform-query"));
        this.formattingMetadataSource = "true".equals(attrs.getValue(this.getUri(), "metadata-source"));
        this.bundleName = attrs.getValue(this.getUri(), "bundle-name");
        String metaDataCoreClass = attrs.getValue(this.getUri(), "impl");
        if (metaDataCoreClass != null) {
            this.dataFactoryCore = (DataFactoryCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, DataFactoryReadHandler.class, DataFactoryCore.class);
            if (this.dataFactoryCore == null) {
                throw new ParseException("Attribute 'impl' references a invalid DataFactoryPropertyCore implementation.", this.getLocator());
            }
        } else {
            this.dataFactoryCore = new DefaultDataFactoryCore();
        }
    }

    protected void doneParsing() throws SAXException {
    }

    public Object getObject() throws SAXException {
        return new DefaultDataFactoryMetaData(this.getName(), this.bundleName, this.keyPrefix, this.isExpert(), this.isPreferred(), this.isHidden(), this.isDeprecated(), this.editable, this.freeformQuery, this.formattingMetadataSource, this.isExperimental(), this.dataFactoryCore, this.compatibilityLevel);
    }
}

