/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultAttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeGroup;
import org.pentaho.reporting.engine.classic.core.metadata.parser.GlobalMetaDefinition;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeGroupRefReadHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(AttributeGroupRefReadHandler.class);
    private AttributeMap<AttributeMetaData> attributes;
    private GlobalMetaDefinition attributeGroups;
    private String bundle;

    public AttributeGroupRefReadHandler(AttributeMap<AttributeMetaData> attributes, GlobalMetaDefinition attributeGroups, String bundle) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (attributeGroups == null) {
            throw new NullPointerException();
        }
        this.attributes = attributes;
        this.attributeGroups = attributeGroups;
        this.bundle = bundle;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String name = attrs.getValue(this.getUri(), "ref");
        if (name == null) {
            throw new ParseException("Attribute 'ref' is undefined", this.getLocator());
        }
        AttributeGroup group = this.attributeGroups.getAttributeGroup(name);
        if (group == null) {
            logger.debug((Object)("There is no attribute-group '" + name + "' defined. Skipping. " + this.getLocator()));
            return;
        }
        AttributeDefinition[] data = group.getMetaData();
        for (int i = 0; i < data.length; ++i) {
            AttributeDefinition handler = data[i];
            String namespace = handler.getNamespace();
            String attrName = handler.getName();
            String namespacePrefix = handler.getNamespacePrefix();
            if (namespacePrefix == null) {
                logger.warn((Object)("Invalid namespace-prefix, skipping attribute " + namespace + ':' + attrName));
                continue;
            }
            String attributeBundle = handler.getBundleName() == null ? this.bundle : handler.getBundleName();
            String prefix = "attribute." + namespacePrefix + '.';
            DefaultAttributeMetaData metaData = new DefaultAttributeMetaData(namespace, attrName, attributeBundle, prefix, handler.getPropertyEditor(), handler.getValueType(), handler.isExpert(), handler.isPreferred(), handler.isHidden(), handler.isDeprecated(), handler.isMandatory(), handler.isComputed(), handler.isTransient(), handler.getValueRole(), handler.isBulk(), handler.isDesignTimeValue(), handler.getAttributeCore(), handler.isExperimental(), handler.getCompatibilityLevel());
            this.attributes.setAttribute(namespace, attrName, (Object)metaData);
        }
    }

    public Object getObject() throws SAXException {
        return null;
    }
}

