/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultAttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ResourceReference;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultExpressionPropertyMetaData
extends AbstractMetaData
implements ExpressionPropertyMetaData {
    private boolean mandatory;
    private String propertyRole;
    private String propertyEditorClass;
    private boolean computed;
    private ExpressionPropertyCore expressionPropertyCore;
    private transient PropertyDescriptor propertyDescriptor;
    private transient SharedBeanInfo beanInfo;

    public DefaultExpressionPropertyMetaData(String name, String bundleLocation, boolean expert, boolean preferred, boolean hidden, boolean deprecated, boolean mandatory, boolean computed, String propertyRole, SharedBeanInfo beanInfo, String propertyEditorClass, ExpressionPropertyCore expressionPropertyCore, boolean experimental, int compatibilityLevel) {
        super(name, bundleLocation, "property.", expert, preferred, hidden, deprecated, experimental, compatibilityLevel);
        if (propertyRole == null) {
            throw new NullPointerException();
        }
        if (beanInfo == null) {
            throw new NullPointerException();
        }
        if (expressionPropertyCore == null) {
            throw new NullPointerException();
        }
        this.beanInfo = beanInfo;
        this.computed = computed;
        this.expressionPropertyCore = expressionPropertyCore;
        this.propertyEditorClass = propertyEditorClass;
        this.mandatory = mandatory;
        this.propertyRole = propertyRole;
    }

    @Override
    public boolean isComputed() {
        return this.computed;
    }

    @Override
    public Class getPropertyType() {
        if (this.propertyDescriptor == null) {
            this.propertyDescriptor = this.beanInfo.getPropertyDescriptor(this.getName());
        }
        return this.propertyDescriptor.getPropertyType();
    }

    @Override
    public String getPropertyRole() {
        return this.propertyRole;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public String[] getReferencedFields(Expression element, Object attributeValue) {
        return this.expressionPropertyCore.getReferencedFields(this, element, attributeValue);
    }

    @Override
    public String[] getReferencedGroups(Expression element, Object attributeValue) {
        return this.expressionPropertyCore.getReferencedGroups(this, element, attributeValue);
    }

    @Override
    public String[] getReferencedElements(Expression expression, Object attributeValue) {
        return this.expressionPropertyCore.getReferencedElements(this, expression, attributeValue);
    }

    @Override
    public ResourceReference[] getReferencedResources(Expression expression, Object attributeValue, Element reportElement, ResourceManager resourceManager) {
        return this.expressionPropertyCore.getReferencedResources(this, expression, attributeValue, reportElement, resourceManager);
    }

    @Override
    public PropertyDescriptor getBeanDescriptor() {
        if (this.propertyDescriptor == null) {
            this.propertyDescriptor = this.beanInfo.getPropertyDescriptor(this.getName());
        }
        return this.propertyDescriptor;
    }

    @Override
    public PropertyEditor getEditor() {
        if (this.propertyEditorClass == null) {
            return null;
        }
        return (PropertyEditor)ObjectUtilities.loadAndInstantiate((String)this.propertyEditorClass, DefaultAttributeMetaData.class, PropertyEditor.class);
    }

    @Override
    public String[] getExtraCalculationFields() {
        return this.expressionPropertyCore.getExtraCalculationFields(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.beanInfo.getBeanClass());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Class c = (Class)in.readObject();
        this.beanInfo = new SharedBeanInfo(c);
    }
}

