/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;

public class DefaultExpressionMetaData
extends AbstractMetaData
implements ExpressionMetaData {
    public static final int NO_LAYOUT_PROCESSOR = 0;
    public static final int ELEMENT_LAYOUT_PROCESSOR = 1;
    public static final int GLOBAL_LAYOUT_PROCESSOR = 2;
    private Class expressionType;
    private Class resultType;
    private HashMap<String, ExpressionPropertyMetaData> properties;
    private int layoutProcessorMode;
    private transient SharedBeanInfo beanInfo;
    private transient String[] propertyKeys;
    private transient ExpressionPropertyMetaData[] propertyMetaData;

    public DefaultExpressionMetaData(String bundleLocation, boolean expert, boolean preferred, boolean hidden, boolean deprecated, Class expressionType, Class resultType, Map<String, ExpressionPropertyMetaData> attributes, SharedBeanInfo beanInfo, int layoutProcessorMode, boolean experimental, int compatibilityLevel) {
        super(expressionType.getName(), bundleLocation, "", expert, preferred, hidden, deprecated, experimental, compatibilityLevel);
        if (resultType == null) {
            throw new NullPointerException();
        }
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (beanInfo == null) {
            throw new NullPointerException();
        }
        this.expressionType = expressionType;
        this.layoutProcessorMode = layoutProcessorMode;
        this.resultType = resultType;
        this.properties = new HashMap<String, ExpressionPropertyMetaData>(attributes);
        this.beanInfo = beanInfo;
    }

    @Override
    protected String computePrefix(String keyPrefix, String name) {
        return "";
    }

    @Override
    public boolean isStatefull() {
        return Function.class.isAssignableFrom(this.getExpressionType());
    }

    @Override
    public Class getResultType() {
        return this.resultType;
    }

    @Override
    public Class getExpressionType() {
        return this.expressionType;
    }

    @Override
    public ExpressionPropertyMetaData getPropertyDescription(String name) {
        return this.properties.get(name);
    }

    @Override
    public Expression create() {
        try {
            return (Expression)this.expressionType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String[] getPropertyNames() {
        if (this.propertyKeys == null) {
            this.propertyKeys = this.properties.keySet().toArray(new String[this.properties.size()]);
        }
        return this.propertyKeys;
    }

    @Override
    public ExpressionPropertyMetaData[] getPropertyDescriptions() {
        if (this.propertyMetaData == null) {
            this.propertyMetaData = this.properties.values().toArray(new ExpressionPropertyMetaData[this.properties.size()]);
        }
        return this.propertyMetaData;
    }

    @Override
    public BeanInfo getBeanDescriptor() throws IntrospectionException {
        return this.beanInfo.getBeanInfo();
    }

    @Override
    public boolean isElementLayoutProcessor() {
        return this.layoutProcessorMode == 1;
    }

    @Override
    public boolean isGlobalLayoutProcessor() {
        return this.layoutProcessorMode == 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultExpressionMetaData that = (DefaultExpressionMetaData)o;
        return this.expressionType.equals(that.expressionType);
    }

    public int hashCode() {
        return this.expressionType.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.beanInfo.getBeanClass());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Class c = (Class)in.readObject();
        this.beanInfo = new SharedBeanInfo(c);
    }
}

