/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.alignment;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.AbstractAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.EndSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineBoxSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.StartSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.TextSequenceElement;

public final class RightAlignmentProcessor
extends AbstractAlignmentProcessor {
    @Override
    protected int handleElement(int start, int count) {
        long lastPageBreak;
        RenderNode[] nodes = this.getNodes();
        InlineSequenceElement[] sequenceElements = this.getSequenceElements();
        long[] elementDimensions = this.getElementDimensions();
        long[] elementPositions = this.getElementPositions();
        int endIndex = start + count;
        long usedWidth = 0L;
        int contentIndex = start;
        InlineSequenceElement contentElement = null;
        for (int i = 0; i < endIndex; ++i) {
            InlineSequenceElement element = sequenceElements[i];
            RenderNode node = nodes[i];
            usedWidth += element.getMaximumWidth(node);
            if (element instanceof StartSequenceElement || element instanceof EndSequenceElement) continue;
            contentElement = element;
            contentIndex = i;
        }
        long nextPosition = this.getStartOfLine() + usedWidth;
        if (nextPosition > (lastPageBreak = this.getPageBreak(this.getPagebreakCount() - 1))) {
            this.rightAlign(start, sequenceElements, nodes, elementPositions, elementDimensions);
            if (contentElement instanceof TextSequenceElement) {
                this.setSkipIndex(endIndex);
                this.setBreakableIndex(contentIndex);
                return start;
            }
            if (start == 0) {
                RenderNode node;
                if (contentElement instanceof InlineBoxSequenceElement && ((node = nodes[contentIndex]).getNodeType() & 2) == 2) {
                    long contentPosition = elementPositions[contentIndex];
                    RenderBox box = (RenderBox)node;
                    long maxWidth = this.getEndOfLine() - contentPosition;
                    this.computeInlineBlock(box, contentPosition, maxWidth);
                    elementDimensions[endIndex - 1] = node.getCachedWidth();
                }
                this.setSkipIndex(endIndex);
            }
            return start;
        }
        if (this.rightAlign(endIndex, sequenceElements, nodes, elementPositions, elementDimensions)) {
            return endIndex;
        }
        return start;
    }

    private boolean rightAlign(int endIndex, InlineSequenceElement[] sequenceElements, RenderNode[] nodes, long[] elementPositions, long[] elementDimensions) {
        long startOfLine = this.getStartOfLine();
        int segment = this.getPagebreakCount() - 1;
        long endPosition = this.getEndOfLine();
        long segmentStart = this.getStartOfSegment(segment);
        for (int i = endIndex - 1; i >= 0; --i) {
            InlineSequenceElement element = sequenceElements[i];
            long elementWidth = element.getMaximumWidth(nodes[i]);
            long elementStart = endPosition - elementWidth;
            if (elementStart < startOfLine) {
                return false;
            }
            while (segment > 0 && elementStart < segmentStart) {
                elementStart = segmentStart - elementWidth;
                segmentStart = this.getStartOfSegment(--segment);
            }
            if (elementStart < segmentStart) {
                return false;
            }
            elementPositions[i] = elementStart;
            elementDimensions[i] = elementWidth;
            endPosition = elementStart;
        }
        return true;
    }

    private long getStartOfSegment(int segment) {
        if (segment == 0) {
            return this.getStartOfLine();
        }
        return this.getPageBreak(segment - 1);
    }
}

