/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import java.awt.Shape;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.SubReportType;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.ModelPrinter;
import org.pentaho.reporting.engine.classic.core.layout.TextProducer;
import org.pentaho.reporting.engine.classic.core.layout.build.BandSectionLayoutModelBuilderContext;
import org.pentaho.reporting.engine.classic.core.layout.build.DefaultLayoutModelBuilderContext;
import org.pentaho.reporting.engine.classic.core.layout.build.GroupSection;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilderContext;
import org.pentaho.reporting.engine.classic.core.layout.build.RenderNodeFactory;
import org.pentaho.reporting.engine.classic.core.layout.build.SectionLayoutModelBuilderContext;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ProgressMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.style.DynamicHeightWrapperStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.DynamicReplacedContentStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.NonDynamicHeightWrapperStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.NonDynamicReplacedContentStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SubReportStyleSheet;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.engine.classic.core.style.AbstractStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.engine.classic.core.util.ShapeDrawable;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class DefaultLayoutModelBuilder
implements LayoutModelBuilder,
Cloneable {
    private static final Log logger = LogFactory.getLog(DefaultLayoutModelBuilder.class);
    private OutputProcessorMetaData metaData;
    private ReportStateKey stateKey;
    private LayoutModelBuilderContext context;
    private RenderNodeFactory renderNodeFactory;
    private TextProducer textProducer;
    private boolean strictLegacyMode;
    private boolean limitedSubReports;
    private boolean collapseProgressMarker = true;
    private ProcessingContext processingContext;
    private String legacySectionName;
    private boolean designtime;

    public DefaultLayoutModelBuilder() {
        this("Section-0");
    }

    public DefaultLayoutModelBuilder(String legacySectionName) {
        this.legacySectionName = legacySectionName;
    }

    protected boolean isAllowMergeSection() {
        return !this.limitedSubReports;
    }

    @Override
    public void initialize(ProcessingContext processingContext, RenderBox parentBox, RenderNodeFactory renderNodeFactory) {
        if (parentBox == null) {
            throw new NullPointerException();
        }
        if (processingContext == null) {
            throw new NullPointerException();
        }
        if (this.processingContext != processingContext) {
            this.processingContext = processingContext;
            this.metaData = processingContext.getOutputProcessorMetaData();
            this.strictLegacyMode = this.metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY);
            this.designtime = this.metaData.isFeatureSupported(OutputProcessorFeature.DESIGNTIME);
            this.renderNodeFactory = renderNodeFactory;
            this.textProducer = this.createTextProducer();
        }
        this.context = new DefaultLayoutModelBuilderContext(null, parentBox);
    }

    protected TextProducer createTextProducer() {
        return new TextProducer(this.metaData);
    }

    protected ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void updateState(ReportStateKey stateKey) {
        this.stateKey = stateKey;
    }

    @Override
    public InstanceID startBox(ReportElement element) {
        SimpleStyleSheet computedStyle = element.getComputedStyle();
        String layout = (String)computedStyle.getStyleProperty(BandStyleKeys.LAYOUT, "canvas");
        return this.startBox(element, computedStyle, layout, false);
    }

    private InstanceID startBox(ReportElement element, StyleSheet styleSheet, String layout, boolean auto) {
        this.closeAutoGeneratedPostfixBoxes();
        if ("auto".equals(layout)) {
            this.context = new DefaultLayoutModelBuilderContext(this.context, this.renderNodeFactory.produceRenderBox(element, styleSheet, layout, this.stateKey));
        } else if ("inline".equals(layout)) {
            if (!this.context.getRenderBox().isAcceptInlineBoxes()) {
                this.context = new DefaultLayoutModelBuilderContext(this.context, this.renderNodeFactory.createAutoParagraph(element, styleSheet, this.stateKey));
                if (this.metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY) || this.metaData.isFeatureSupported(OutputProcessorFeature.PRD_3750)) {
                    this.context.setAutoGeneratedWrapperBox(true);
                    this.context = new DefaultLayoutModelBuilderContext(this.context, this.renderNodeFactory.produceRenderBox(element, styleSheet, "::paragraph-linebox", this.stateKey));
                }
            } else {
                this.context = new DefaultLayoutModelBuilderContext(this.context, this.renderNodeFactory.produceRenderBox(element, styleSheet, layout, this.stateKey));
            }
        } else if (this.context.getRenderBox().isAcceptInlineBoxes()) {
            this.context = new DefaultLayoutModelBuilderContext(this.context, this.renderNodeFactory.produceRenderBox(element, styleSheet, "inline", this.stateKey));
        } else if ("table-cell".equals(layout)) {
            if (278530 != this.context.getRenderBox().getLayoutNodeType()) {
                this.startBox(element, this.renderNodeFactory.createAutoGeneratedSectionStyleSheet(styleSheet), "table-row", true);
            }
            this.context = new DefaultLayoutModelBuilderContext(this.context, this.renderNodeFactory.produceRenderBox(element, styleSheet, layout, this.stateKey));
        } else if ("table-row".equals(layout)) {
            if (270338 != this.context.getRenderBox().getLayoutNodeType()) {
                this.startBox(element, this.renderNodeFactory.createAutoGeneratedSectionStyleSheet(styleSheet), "table-body", true);
            }
            this.context = new DefaultLayoutModelBuilderContext(this.context, this.renderNodeFactory.produceRenderBox(element, styleSheet, layout, this.stateKey));
        } else if ("table-body".equals(layout) || "table-footer".equals(layout) || "table-header".equals(layout)) {
            if (266242 != this.context.getRenderBox().getLayoutNodeType()) {
                this.startBox(element, this.renderNodeFactory.createAutoGeneratedSectionStyleSheet(styleSheet), "table", true);
            }
            this.context = new DefaultLayoutModelBuilderContext(this.context, this.renderNodeFactory.produceRenderBox(element, styleSheet, layout, this.stateKey));
        } else {
            this.context = new DefaultLayoutModelBuilderContext(this.context, this.renderNodeFactory.produceRenderBox(element, styleSheet, layout, this.stateKey));
        }
        this.context.setAutoGeneratedWrapperBox(auto);
        this.context.setEmpty(DefaultLayoutModelBuilder.isEmptyElement(element, styleSheet, this.metaData));
        if (!auto) {
            if (DefaultLayoutModelBuilder.isControlBand(styleSheet)) {
                this.context.getRenderBox().getStaticBoxLayoutProperties().setPlaceholderBox(StaticBoxLayoutProperties.PlaceholderType.SECTION);
            } else {
                this.context.getRenderBox().getStaticBoxLayoutProperties().setPlaceholderBox(StaticBoxLayoutProperties.PlaceholderType.NONE);
            }
        }
        this.textProducer.startText();
        return this.context.getRenderBox().getInstanceId();
    }

    private static boolean isEmptyElement(ReportElement band, StyleSheet style, OutputProcessorMetaData metaData) {
        Band b;
        if (DefaultLayoutModelBuilder.isControlBand(style)) {
            return false;
        }
        if (metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY) && band instanceof Band && (b = (Band)band).getElementCount() > 0) {
            return false;
        }
        if ("auto".equals(style.getStyleProperty(BandStyleKeys.LAYOUT))) {
            return true;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.HEIGHT, style)) {
            return false;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.WIDTH, style)) {
            return false;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.POS_Y, style)) {
            return false;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.POS_X, style)) {
            return false;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.MIN_HEIGHT, style)) {
            return false;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.MIN_WIDTH, style)) {
            return false;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.PADDING_TOP, style)) {
            return false;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.PADDING_LEFT, style)) {
            return false;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.PADDING_BOTTOM, style)) {
            return false;
        }
        if (DefaultLayoutModelBuilder.isLengthDefined(ElementStyleKeys.PADDING_RIGHT, style)) {
            return false;
        }
        if (!BorderStyle.NONE.equals(style.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE, BorderStyle.NONE))) {
            return false;
        }
        if (!BorderStyle.NONE.equals(style.getStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE, BorderStyle.NONE))) {
            return false;
        }
        if (!BorderStyle.NONE.equals(style.getStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE, BorderStyle.NONE))) {
            return false;
        }
        if (!BorderStyle.NONE.equals(style.getStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE, BorderStyle.NONE))) {
            return false;
        }
        if (style.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR) != null) {
            return false;
        }
        return !metaData.isExtraContentElement(band.getStyle(), band.getAttributes());
    }

    public static boolean isControlBand(StyleSheet style) {
        if (style.getStyleProperty(BandStyleKeys.COMPUTED_SHEETNAME) != null) {
            return true;
        }
        if (style.getStyleProperty(BandStyleKeys.BOOKMARK) != null) {
            return true;
        }
        if (!"inline".equals(style.getStyleProperty(BandStyleKeys.LAYOUT))) {
            if (Boolean.TRUE.equals(style.getStyleProperty(BandStyleKeys.PAGEBREAK_AFTER))) {
                return true;
            }
            if (Boolean.TRUE.equals(style.getStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isLengthDefined(StyleKey key, StyleSheet styleSheet) {
        if (key.isInheritable() && !styleSheet.isLocalKey(key)) {
            return false;
        }
        Object o = styleSheet.getStyleProperty(key, null);
        if (o == null) {
            return false;
        }
        if (!(o instanceof Number)) {
            return false;
        }
        Number n = (Number)o;
        return n.doubleValue() != 0.0;
    }

    @Override
    public void startSection() {
        String layoutMode = this.metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY) ? "block" : "auto";
        RenderBox renderBox = this.renderNodeFactory.produceSectionBox(layoutMode, null);
        this.context = this.isAllowMergeSection() ? new BandSectionLayoutModelBuilderContext(this.metaData, this.context, renderBox) : new DefaultLayoutModelBuilderContext(this.context, renderBox);
        this.context.setEmpty(true);
        if (this.legacySectionName != null) {
            this.context.getRenderBox().setName(this.legacySectionName);
        }
        this.textProducer.startText();
    }

    @Override
    public void startSection(ReportElement element, int sectionSize) {
        String layout;
        SimpleStyleSheet resolverStyleSheet = element.getComputedStyle();
        boolean legacyMode = this.metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY);
        String layoutMode = legacyMode ? "block" : ("inline".equals(layout = (String)resolverStyleSheet.getStyleProperty(BandStyleKeys.LAYOUT, "auto")) && !this.context.getRenderBox().isAcceptInlineBoxes() ? "block" : layout);
        GroupSection groupSection = new GroupSection(this.renderNodeFactory.produceRenderBox(element, resolverStyleSheet, layoutMode, null), this.renderNodeFactory.createAutoGeneratedSectionStyleSheet(resolverStyleSheet), sectionSize, legacyMode);
        this.context = new SectionLayoutModelBuilderContext(this.context, groupSection, legacyMode);
        this.context.setEmpty(true);
        if (element instanceof GroupBody || element instanceof Group) {
            this.context.getRenderBox().getStaticBoxLayoutProperties().setPlaceholderBox(StaticBoxLayoutProperties.PlaceholderType.SECTION);
        }
        this.textProducer.startText();
    }

    private void closeAutoGeneratedPostfixBoxes() {
    }

    @Override
    public boolean isEmptyElementsHaveSignificance() {
        if (this.designtime) {
            return true;
        }
        RenderBox box = this.context.getRenderBox();
        return box.isEmptyNodesHaveSignificance();
    }

    public boolean isEmptyElementsHaveSignificanceInParent() {
        LayoutModelBuilderContext parent = this.context.getParent();
        if (parent == null) {
            return false;
        }
        RenderBox box = parent.getRenderBox();
        return box.isEmptyNodesHaveSignificance();
    }

    private void ensureEmptyChildIsAdded(RenderBox parent, ReportElement element) {
        SimpleStyleSheet resolverStyleSheet = element.getComputedStyle();
        RenderBox box = parent.isAcceptInlineBoxes() ? this.renderNodeFactory.produceRenderBox(element, resolverStyleSheet, "inline", this.getStateKey()) : this.renderNodeFactory.produceRenderBox(element, resolverStyleSheet, "block", this.getStateKey());
        box.getStaticBoxLayoutProperties().setPlaceholderBox(StaticBoxLayoutProperties.PlaceholderType.SECTION);
        box.close();
        parent.addChild(box);
    }

    @Override
    public void processContent(ReportElement element, Object computedValue, Object rawValue) {
        if (computedValue == null) {
            SimpleStyleSheet resolvedStyle = element.getComputedStyle();
            RenderBox parentRenderBox = this.context.getRenderBox();
            if (parentRenderBox.isEmptyNodesHaveSignificance() || this.metaData.isExtraContentElement(resolvedStyle, element.getAttributes())) {
                this.ensureEmptyChildIsAdded(parentRenderBox, element);
                this.context.setEmpty(false);
            }
            return;
        }
        if (String.class.equals(computedValue.getClass())) {
            this.processText(element, (String)computedValue, rawValue);
        } else if (computedValue instanceof Shape) {
            SimpleStyleSheet resolvedStyle = element.getComputedStyle();
            Shape shape = (Shape)computedValue;
            ShapeDrawable reportDrawable = new ShapeDrawable(shape, resolvedStyle.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO));
            this.processReportDrawable(element, reportDrawable, rawValue);
        } else if (computedValue instanceof ReportDrawable) {
            this.processReportDrawable(element, (ReportDrawable)computedValue, rawValue);
        } else if (computedValue instanceof ImageContainer || computedValue instanceof DrawableWrapper) {
            this.processReplacedContent(element, computedValue, rawValue);
        } else if (DrawableWrapper.isDrawable((Object)computedValue)) {
            this.processReplacedContent(element, new DrawableWrapper(computedValue), rawValue);
        } else {
            this.processText(element, String.valueOf(computedValue), rawValue);
        }
    }

    private boolean isTableContext(RenderNode node) {
        while (node != null) {
            if ((node.getLayoutNodeType() & 0x40002) == 262146) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    protected void processText(ReportElement element, String computedValue, Object rawValue) {
        SimpleStyleSheet resolverStyleSheet = element.getComputedStyle();
        if (computedValue != null && resolverStyleSheet.getBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT)) {
            computedValue = computedValue.trim();
        }
        if (!this.context.getRenderBox().isAcceptInlineBoxes()) {
            int parentNodeType = this.context.getRenderBox().getLayoutNodeType();
            AbstractStyleSheet elementStyle = this.strictLegacyMode && (parentNodeType & 0x22) == 34 ? (!this.isTableContext(this.context.getRenderBox()) && !resolverStyleSheet.getBooleanStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT) ? new NonDynamicHeightWrapperStyleSheet(resolverStyleSheet) : new DynamicHeightWrapperStyleSheet(resolverStyleSheet)) : resolverStyleSheet;
            this.textProducer.startText();
            RenderBox renderBox = this.renderNodeFactory.createAutoParagraph(element, elementStyle, this.stateKey);
            RenderNode[] renderNodes = this.textProducer.getRenderNodes(element, elementStyle, computedValue);
            renderBox.addChilds(renderNodes);
            renderBox.setRawValue(rawValue);
            this.context = new DefaultLayoutModelBuilderContext(this.context, renderBox);
            this.context.setEmpty(renderNodes.length == 0 && DefaultLayoutModelBuilder.isEmptyElement(element, resolverStyleSheet, this.metaData));
            this.context = this.context.close();
        } else {
            StyleSheet safeElementStyle = this.renderNodeFactory.createStyle(resolverStyleSheet);
            RenderBox renderBox = this.renderNodeFactory.produceRenderBox(element, resolverStyleSheet, "inline", this.stateKey);
            RenderNode[] renderNodes = this.textProducer.getRenderNodes(element, safeElementStyle, computedValue);
            renderBox.addChilds(renderNodes);
            renderBox.setRawValue(rawValue);
            this.context = new DefaultLayoutModelBuilderContext(this.context, renderBox);
            this.context.setEmpty(renderNodes.length == 0 && DefaultLayoutModelBuilder.isEmptyElement(element, resolverStyleSheet, this.metaData));
            this.context = this.context.close();
        }
    }

    protected void processReportDrawable(ReportElement element, ReportDrawable reportDrawable, Object rawValue) {
        SimpleStyleSheet resolverStyleSheet = element.getComputedStyle();
        reportDrawable.setStyleSheet(resolverStyleSheet);
        reportDrawable.setConfiguration(this.processingContext.getConfiguration());
        reportDrawable.setResourceBundleFactory(this.processingContext.getResourceBundleFactory());
        if (reportDrawable instanceof DrawableWrapper) {
            this.processReplacedContent(element, reportDrawable, rawValue);
        } else {
            this.processReplacedContent(element, new DrawableWrapper((Object)reportDrawable), rawValue);
        }
    }

    protected void processReplacedContent(ReportElement element, Object value, Object rawValue) {
        RenderBox box = this.context.getRenderBox();
        SimpleStyleSheet resolverStyleSheet = element.getComputedStyle();
        AbstractStyleSheet elementStyle = !box.isAcceptInlineBoxes() ? (!this.isTableContext(box) && !resolverStyleSheet.getBooleanStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT) ? new NonDynamicReplacedContentStyleSheet(resolverStyleSheet) : new DynamicReplacedContentStyleSheet(resolverStyleSheet)) : resolverStyleSheet;
        RenderableReplacedContentBox child = this.renderNodeFactory.createReplacedContent(element, elementStyle, value, rawValue, this.stateKey);
        child.setName(element.getName());
        this.context.addChild(child);
        this.context.setEmpty(false);
    }

    @Override
    public boolean finishBox() {
        boolean empty = this.context.isEmpty();
        if (empty && this.isEmptyElementsHaveSignificanceInParent()) {
            this.context.setEmpty(false);
            empty = false;
        }
        this.context = this.context.close();
        while (this.context.isAutoGeneratedWrapperBox()) {
            this.context = this.context.close();
        }
        return empty;
    }

    @Override
    public void endSection() {
        this.context = this.context.close();
        while (this.context.isAutoGeneratedWrapperBox()) {
            this.context = this.context.close();
        }
    }

    @Override
    public InstanceID createSubflowPlaceholder(ReportElement element) {
        SimpleStyleSheet resolverStyleSheet = element.getComputedStyle();
        RenderBox subReportBox = this.renderNodeFactory.produceSubReportPlaceholder(element, resolverStyleSheet, this.stateKey);
        this.context.addChild(subReportBox);
        this.context.setEmpty(false);
        return subReportBox.getInstanceId();
    }

    @Override
    public InlineSubreportMarker processSubReport(SubReport element) {
        if (this.isLimitedSubReports()) {
            logger.debug((Object)"Not adding subreport: Subreports in header or footer area are not allowed.");
            return null;
        }
        RenderBox parentBox = this.context.getRenderBox();
        if (parentBox.isAcceptInlineBoxes()) {
            logger.warn((Object)"Not adding subreport: Subreports in inline-contexts are not supported.");
            return null;
        }
        SimpleStyleSheet resolverStyleSheet = element.getComputedStyle();
        RenderBox subReportBox = this.renderNodeFactory.produceSubReportPlaceholder(element, resolverStyleSheet, this.stateKey);
        this.context.addChild(subReportBox);
        this.context.setEmpty(false);
        InstanceID subReportBoxId = subReportBox.getInstanceId();
        return new InlineSubreportMarker(element, subReportBoxId, SubReportProcessType.INLINE);
    }

    @Override
    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    @Override
    public void print() {
        ModelPrinter.INSTANCE.print(this.context.getRenderBox());
    }

    protected LayoutModelBuilderContext getContext() {
        return this.context;
    }

    protected void setContext(LayoutModelBuilderContext context) {
        this.context = context;
    }

    protected TextProducer getTextProducer() {
        return this.textProducer;
    }

    protected RenderNodeFactory getRenderNodeFactory() {
        return this.renderNodeFactory;
    }

    protected ReportStateKey getStateKey() {
        return this.stateKey;
    }

    @Override
    public void startSubFlow(InstanceID insertationPoint) {
        if (insertationPoint == null) {
            throw new IllegalStateException();
        }
        RenderBox rootBox = this.getLayoutRoot();
        RenderBox box = (RenderBox)rootBox.findNodeById(insertationPoint);
        if (box == null) {
            throw new IllegalStateException("Unable to locate insertation point for subreport: " + insertationPoint);
        }
        this.pushBoxToContext(box, false);
    }

    protected void pushBoxToContext(RenderBox box, boolean empty) {
        this.context = new DefaultLayoutModelBuilderContext(this.context, box);
        this.context.setEmpty(empty);
        this.textProducer.startText();
    }

    @Override
    public void startSubFlow(ReportElement element) {
        RenderBox box;
        SimpleStyleSheet resolverStyleSheet = element.getComputedStyle();
        if (this.metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY)) {
            SubReportStyleSheet styleSheet = new SubReportStyleSheet(resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE), resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER));
            SimpleStyleSheet reportStyle = new SimpleStyleSheet(styleSheet);
            BoxDefinition boxDefinition = this.renderNodeFactory.getBoxDefinition(reportStyle);
            box = new BlockRenderBox(reportStyle, element.getObjectID(), boxDefinition, SubReportType.INSTANCE, element.getAttributes(), null);
        } else {
            box = this.renderNodeFactory.produceRenderBox(element, resolverStyleSheet, "block", this.stateKey);
        }
        box.getStaticBoxLayoutProperties().setPlaceholderBox(StaticBoxLayoutProperties.PlaceholderType.SECTION);
        if (element.getName() != null) {
            box.setName("Banded-SubReport-Section: name=" + element.getName());
        } else {
            box.setName("Banded-SubReport-Section");
        }
        this.pushBoxToContext(box, false);
    }

    private RenderBox getLayoutRoot() {
        for (LayoutModelBuilderContext context = this.context; context != null; context = context.getParent()) {
            if (context.getParent() != null) continue;
            return context.getRenderBox();
        }
        throw new IllegalStateException();
    }

    @Override
    public void suspendSubFlow() {
        this.context = this.context.getParent();
    }

    @Override
    public void endSubFlow() {
        this.endSection();
    }

    @Override
    public void addProgressMarkerBox() {
        RenderBox parent = this.context.getRenderBox();
        RenderNode child = parent.getLastChild();
        if (this.isCollapseProgressMarker() && child != null && child.getNodeType() == 0x1000012) {
            ProgressMarkerRenderBox markerRenderBox = (ProgressMarkerRenderBox)child;
            markerRenderBox.setStateKey(this.stateKey);
        } else {
            ProgressMarkerRenderBox markerBox = new ProgressMarkerRenderBox();
            markerBox.setStateKey(this.stateKey);
            this.context.addChild(markerBox);
            markerBox.close();
        }
        this.context.setEmpty(false);
    }

    @Override
    public void addManualPageBreakBox(long range) {
        RenderBox breakIndicatorBox = this.renderNodeFactory.createPageBreakIndicatorBox(this.stateKey, range);
        this.context.addChild(breakIndicatorBox);
        this.context.setEmpty(false);
    }

    @Override
    public void setCollapseProgressMarker(boolean collapseProgressMarker) {
        this.collapseProgressMarker = collapseProgressMarker;
    }

    public boolean isCollapseProgressMarker() {
        return this.collapseProgressMarker;
    }

    @Override
    public void setLimitedSubReports(boolean limitedSubReports) {
        this.limitedSubReports = limitedSubReports;
    }

    public boolean isLimitedSubReports() {
        return this.limitedSubReports;
    }

    @Override
    public DefaultLayoutModelBuilder clone() {
        try {
            return (DefaultLayoutModelBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public LayoutModelBuilder deriveForPageBreak() {
        DefaultLayoutModelBuilder clone = this.clone();
        clone.context = this.context.deriveForPagebreak();
        return clone;
    }

    @Override
    public LayoutModelBuilder deriveForStorage(RenderBox clonedContent) {
        DefaultLayoutModelBuilder clone = this.clone();
        clone.context = this.context.deriveForStorage(clonedContent);
        return clone;
    }

    @Override
    public void restoreStateAfterRollback() {
        for (LayoutModelBuilderContext c = this.context; c != null; c = c.getParent()) {
            c.restoreStateAfterRollback();
        }
    }

    @Override
    public void validateAfterCommit() {
        for (LayoutModelBuilderContext c = this.context; c != null; c = c.getParent()) {
            c.validateAfterCommit();
        }
    }

    @Override
    public void performParanoidModelCheck(RenderBox logicalPageBox) {
        for (LayoutModelBuilderContext c = this.context; c != null; c = c.getParent()) {
            c.performParanoidModelCheck();
            RenderBox renderBox = c.getRenderBox();
            this.testIsLogicalPageParent(renderBox, logicalPageBox);
        }
    }

    private void testIsLogicalPageParent(RenderBox b, RenderBox logicalPageBox) {
        while (b != null) {
            if (b == logicalPageBox) {
                return;
            }
            b = b.getParent();
        }
        throw new IllegalStateException();
    }

    @Override
    public void legacyFlagNotEmpty() {
        this.context.setEmpty(false);
    }

    @Override
    public void legacyAddPlaceholder(ReportElement element) {
        RenderBox parentRenderBox = this.context.getRenderBox();
        this.ensureEmptyChildIsAdded(parentRenderBox, element);
        this.context.setEmpty(false);
    }

    @Override
    public RenderNode dangerousRawAccess() {
        return this.context.getRenderBox();
    }

    @Override
    public void close() {
    }
}

