/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.formula;

import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeUtil;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;
import org.pentaho.reporting.libraries.formula.util.URLEncoder;

public class MParameterTextFunction
implements Function {
    private static final Log logger = LogFactory.getLog(MParameterTextFunction.class);

    public String getCanonicalName() {
        return "MPARAMETERTEXT";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        String encodingResult;
        boolean urlEncode;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 2 || parameterCount > 4) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Object[] rawValue = parameters.getValue(0);
        if (!(rawValue instanceof Object[])) {
            rawValue = TypeUtil.normalize((Sequence)context.getTypeRegistry().convertToSequence(parameters.getType(0), (Object)rawValue));
        }
        String parameterName = context.getTypeRegistry().convertToText(parameters.getType(1), parameters.getValue(1));
        if (parameterCount > 2) {
            boolean bl = urlEncode = !Boolean.FALSE.equals(context.getTypeRegistry().convertToLogical(parameters.getType(2), parameters.getValue(2)));
            if (parameterCount == 4) {
                Type encodingType = parameters.getType(3);
                Object encodingValue = parameters.getValue(3);
                encodingResult = context.getTypeRegistry().convertToText(encodingType, encodingValue);
                if (encodingResult == null) {
                    throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
                }
            } else {
                encodingResult = context.getConfiguration().getConfigProperty("org.pentaho.reporting.libraries.formula.URLEncoding", "UTF-8");
            }
        } else {
            urlEncode = true;
            encodingResult = context.getConfiguration().getConfigProperty("org.pentaho.reporting.libraries.formula.URLEncoding", "UTF-8");
        }
        try {
            Object[] value = rawValue;
            StringBuffer b = new StringBuffer(1000);
            for (int i = 0; i < value.length; ++i) {
                String s;
                if (i != 0) {
                    b.append("&");
                    b.append(URLEncoder.encode((String)parameterName, (String)encodingResult));
                    b.append("=");
                }
                try {
                    Object o = value[i];
                    s = ConverterRegistry.toAttributeValue(o);
                }
                catch (BeanException e) {
                    logger.warn((Object)("MPARAMETERTEXT: Failed to convert value " + rawValue + " (" + rawValue.getClass() + ")"), (Throwable)e);
                    throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
                }
                if (s == null) continue;
                if (urlEncode) {
                    b.append(URLEncoder.encode((String)s, (String)encodingResult));
                    continue;
                }
                b.append(s);
            }
            return new TypeValuePair((Type)TextType.TYPE, (Object)b.toString());
        }
        catch (UnsupportedEncodingException use) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
    }
}

