/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class ResourceFieldType
extends AbstractElementType {
    public static final ResourceFieldType INSTANCE = new ResourceFieldType();
    private static final Log logger = LogFactory.getLog(ResourceFieldType.class);

    public ResourceFieldType() {
        super("resource-field");
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object resourceKeyRaw = ElementTypeUtils.queryFieldName(element);
        if (resourceKeyRaw == null) {
            return "<null>";
        }
        return resourceKeyRaw.toString();
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object resourceKeyRaw = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (resourceKeyRaw == null) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        String resourceKey = String.valueOf(resourceKeyRaw);
        String resourceId = ElementTypeUtils.queryResourceId(runtime, element);
        if (resourceId == null) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        try {
            ResourceBundleFactory resourceBundleFactory = runtime.getResourceBundleFactory();
            ResourceBundle bundle = resourceBundleFactory.getResourceBundle(resourceId);
            if (bundle != null) {
                return bundle.getString(resourceKey);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to retrieve a value for key " + resourceId));
        }
        return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
    }
}

