/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class MessageType
extends AbstractElementType {
    public static final MessageType INSTANCE = new MessageType();

    public MessageType() {
        super("message");
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        String value;
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        Object message = ElementTypeUtils.queryStaticValue(element);
        if (message == null) {
            return nullValue;
        }
        MessageTypeContext context = element.getElementContext(MessageTypeContext.class);
        MessageFormatSupport messageFormatFilter = context.messageFormatFilter;
        messageFormatFilter.setFormatString(String.valueOf(message));
        Object messageNullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "message-null-value");
        if (messageNullValue != null) {
            messageFormatFilter.setNullString(String.valueOf(messageNullValue));
        } else if (nullValue != null) {
            messageFormatFilter.setNullString(String.valueOf(nullValue));
        } else {
            messageFormatFilter.setNullString(null);
        }
        ResourceBundleFactory resourceBundleFactory = runtime.getResourceBundleFactory();
        Locale newLocale = resourceBundleFactory.getLocale();
        if (!ObjectUtilities.equal((Object)newLocale, (Object)messageFormatFilter.getLocale())) {
            messageFormatFilter.setLocale(resourceBundleFactory.getLocale());
        }
        if ((value = messageFormatFilter.performFormat(runtime.getDataRow())) == null) {
            return nullValue;
        }
        return String.valueOf(value);
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object message = ElementTypeUtils.queryStaticValue(element);
        if (message == null || String.valueOf(message).length() == 0) {
            return element.getElementType().getMetaData().getName();
        }
        return message;
    }

    @Override
    public void configureDesignTimeDefaults(ReportElement element, Locale locale) {
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", "Message");
    }

    public static class MessageTypeContext {
        public MessageFormatSupport messageFormatFilter = new MessageFormatSupport();
    }
}

