/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formatting.FastDateFormat;

public class DateFieldType
extends AbstractElementType
implements RawDataSource {
    public static final DateFieldType INSTANCE = new DateFieldType();
    public static final String DEFAULT_FORMAT = "dd.MM.yyyy HH:mm:ss";

    public DateFieldType() {
        super("date-field");
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
        Object staticValue = ElementTypeUtils.queryStaticValue(element);
        if (staticValue instanceof Date) {
            if (formatStringRaw == null) {
                formatStringRaw = DEFAULT_FORMAT;
            }
            Locale locale = runtime.getResourceBundleFactory().getLocale();
            TimeZone timeZone = runtime.getResourceBundleFactory().getTimeZone();
            SimpleDateFormat dateFormat = new SimpleDateFormat(String.valueOf(formatStringRaw), locale);
            dateFormat.setDateFormatSymbols(new DateFormatSymbols(locale));
            dateFormat.setTimeZone(timeZone);
            return dateFormat.format(staticValue);
        }
        return ElementTypeUtils.queryFieldName(element);
    }

    @Override
    public Object getRawValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object retval = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (!(retval instanceof Date)) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        return retval;
    }

    @Override
    public FormatSpecification getFormatString(ExpressionRuntime runtime, ReportElement element, FormatSpecification formatSpecification) {
        Object formatStringRaw;
        if (formatSpecification == null) {
            formatSpecification = new FormatSpecification();
        }
        if ((formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string")) == null) {
            formatSpecification.redefine(1, DEFAULT_FORMAT);
        } else {
            formatSpecification.redefine(1, String.valueOf(formatStringRaw));
        }
        return formatSpecification;
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object retval = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (!(retval instanceof Date)) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        Object formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
        if (formatStringRaw == null) {
            formatStringRaw = "EEE MMM dd HH:mm:ss zzz yyyy";
        }
        try {
            Locale locale = runtime.getResourceBundleFactory().getLocale();
            TimeZone timeZone = runtime.getResourceBundleFactory().getTimeZone();
            DateFieldTypeContext context = element.getElementContext(DateFieldTypeContext.class);
            if (context.dateFormat == null) {
                context.formatString = String.valueOf(formatStringRaw);
                context.locale = locale;
                context.timeZone = timeZone;
                context.dateFormat = new FastDateFormat(context.formatString, locale, timeZone);
            } else if (!(ObjectUtilities.equal((Object)context.formatString, (Object)formatStringRaw) && ObjectUtilities.equal((Object)context.locale, (Object)locale) && ObjectUtilities.equal((Object)context.timeZone, (Object)timeZone))) {
                context.timeZone = timeZone;
                context.locale = locale;
                context.formatString = String.valueOf(formatStringRaw);
                context.dateFormat = new FastDateFormat(context.formatString, locale, timeZone);
            }
            return context.dateFormat.format(retval);
        }
        catch (Exception e) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
    }

    public static class DateFieldTypeContext {
        public transient FastDateFormat dateFormat;
        public transient Locale locale;
        public transient String formatString;
        public transient TimeZone timeZone;
    }
}

