/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class MessageFormatFilter
implements DataSource {
    private MessageFormatSupport messageFormatSupport = new MessageFormatSupport();
    private transient Locale locale;

    public void setFormatString(String format) {
        this.messageFormatSupport.setFormatString(format);
    }

    public String getFormatString() {
        return this.messageFormatSupport.getFormatString();
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            return null;
        }
        ResourceBundleFactory resourceBundleFactory = runtime.getResourceBundleFactory();
        Locale newLocale = resourceBundleFactory.getLocale();
        if (!ObjectUtilities.equal((Object)newLocale, (Object)this.locale)) {
            this.messageFormatSupport.setLocale(resourceBundleFactory.getLocale());
            this.locale = newLocale;
        }
        return this.messageFormatSupport.performFormat(runtime.getDataRow());
    }

    @Override
    public MessageFormatFilter clone() throws CloneNotSupportedException {
        MessageFormatFilter mf = (MessageFormatFilter)super.clone();
        mf.messageFormatSupport = (MessageFormatSupport)this.messageFormatSupport.clone();
        return mf;
    }

    public String getNullString() {
        return this.messageFormatSupport.getNullString();
    }

    public void setNullString(String nullString) {
        this.messageFormatSupport.setNullString(nullString);
    }
}

