/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.FormatFilter;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DateFormatFilter
extends FormatFilter {
    private transient TimeZone timeZone;

    public DateFormatFilter() {
        this.setFormatter(DateFormat.getInstance());
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.getFormatter();
    }

    public void setDateFormat(DateFormat format) {
        super.setFormatter(format);
    }

    @Override
    public void setFormatter(Format format) {
        DateFormat dfmt = (DateFormat)format;
        super.setFormatter(dfmt);
    }

    @Override
    public Object getRawValue(ExpressionRuntime runtime, ReportElement element) {
        Object value = super.getRawValue(runtime, element);
        if (value instanceof Number) {
            Number number = (Number)value;
            return new Date(number.longValue());
        }
        return value;
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        TimeZone timeZone = runtime.getResourceBundleFactory().getTimeZone();
        if (!ObjectUtilities.equal((Object)timeZone, (Object)this.timeZone)) {
            this.timeZone = timeZone;
            this.getDateFormat().setTimeZone(timeZone);
        }
        return super.getValue(runtime, element);
    }

    @Override
    public FormatSpecification getFormatString(ExpressionRuntime runtime, ReportElement element, FormatSpecification formatSpecification) {
        DataSource source = this.getDataSource();
        if (source instanceof RawDataSource) {
            RawDataSource rds = (RawDataSource)source;
            return rds.getFormatString(runtime, element, formatSpecification);
        }
        if (formatSpecification == null) {
            formatSpecification = new FormatSpecification();
        }
        formatSpecification.redefine(0, null);
        return formatSpecification;
    }
}

