/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime;

import java.awt.Window;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModelFactory;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.libraries.designtime.swing.settings.DefaultLocaleSettings;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;

public class DefaultDesignTimeContext
implements DesignTimeContext {
    private final DesignTimeDataFactoryContext dataFactoryContext;
    private final AbstractReportDefinition report;
    private final LocaleSettings localeSettings;
    private Window parentWindow;
    private ContextAwareDataSchemaModel dataSchemaModel;

    public DefaultDesignTimeContext(AbstractReportDefinition report) {
        if (report == null) {
            throw new NullPointerException();
        }
        this.report = report;
        this.localeSettings = new DefaultLocaleSettings();
        this.dataFactoryContext = new DesignTimeDataFactoryContext();
    }

    @Override
    public AbstractReportDefinition getReport() {
        return this.report;
    }

    public void setParentWindow(Window parentWindow) {
        this.parentWindow = parentWindow;
    }

    @Override
    public Window getParentWindow() {
        return this.parentWindow;
    }

    @Override
    public DataSchemaModel getDataSchemaModel() {
        if (this.dataSchemaModel == null) {
            ContextAwareDataSchemaModelFactory factory = (ContextAwareDataSchemaModelFactory)ClassicEngineBoot.getInstance().getObjectFactory().get(ContextAwareDataSchemaModelFactory.class);
            this.dataSchemaModel = factory.create(this.report);
        }
        return this.dataSchemaModel;
    }

    @Override
    public void error(Exception e) {
        e.printStackTrace();
    }

    @Override
    public void userError(Exception e) {
        e.printStackTrace();
    }

    @Override
    public LocaleSettings getLocaleSettings() {
        return this.localeSettings;
    }

    @Override
    public boolean isShowExpertItems() {
        return true;
    }

    @Override
    public boolean isShowDeprecatedItems() {
        return true;
    }

    @Override
    public DesignTimeDataFactoryContext getDataFactoryContext() {
        return this.dataFactoryContext;
    }
}

