/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public abstract class Group
extends Section {
    private GroupBody body;
    private transient String generatedName;

    protected Group() {
        this.body = this.createDefaultBody();
        this.registerAsChild(this.body);
    }

    protected Group(GroupBody body) {
        if (body == null) {
            throw new NullPointerException();
        }
        this.body = body;
        this.registerAsChild(body);
    }

    public GroupBody getBody() {
        return this.body;
    }

    public void setBody(GroupBody body) {
        if (body == null) {
            throw new NullPointerException("The body must not be null");
        }
        this.validateLooping(body);
        if (this.unregisterParent(body)) {
            return;
        }
        GroupBody element = this.body;
        this.body.setParent(null);
        this.body = body;
        this.body.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.body);
    }

    @Override
    public Group clone() {
        Group g = (Group)super.clone();
        g.body = (GroupBody)this.body.clone();
        g.registerAsChild(g.body);
        return g;
    }

    @Override
    public Group derive(boolean preserveElementInstanceIds) {
        Group g = (Group)super.derive(preserveElementInstanceIds);
        g.body = (GroupBody)this.body.derive(preserveElementInstanceIds);
        g.registerAsChild(g.body);
        return g;
    }

    public abstract boolean isGroupChange(DataRow var1);

    @Override
    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.body == element) {
            this.body.setParent(null);
            this.body = this.createDefaultBody();
            this.body.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.body);
        }
    }

    protected abstract GroupBody createDefaultBody();

    @Override
    protected void notifyElement() {
        this.generatedName = null;
    }

    public String getGeneratedName() {
        String name;
        String generatedName = this.generatedName;
        if (generatedName != null) {
            return generatedName;
        }
        this.generatedName = name = this.generatedName();
        return name;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (StringUtils.isEmpty((String)name)) {
            return this.getGeneratedName();
        }
        return name;
    }

    public boolean matches(String name) {
        if (ObjectUtilities.equal((Object)name, (Object)this.getName())) {
            return true;
        }
        return ObjectUtilities.equal((Object)name, (Object)this.getGeneratedName());
    }

    private String generatedName() {
        int parentGroupCounter = 0;
        for (Section parent = this.getParentSection(); parent != null && !(parent instanceof ReportDefinition); parent = parent.getParentSection()) {
            if (!(parent instanceof Group)) continue;
            ++parentGroupCounter;
        }
        return "::group-" + parentGroupCounter;
    }

    public abstract List<SortConstraint> getSortingConstraint();

    protected List<SortConstraint> mapFields(List<String> fields) {
        boolean ascending = this.isAscendingSortOrder();
        ArrayList<SortConstraint> c = new ArrayList<SortConstraint>(fields.size());
        for (String field : fields) {
            if (StringUtils.isEmpty((String)field)) continue;
            c.add(new SortConstraint(field, ascending));
        }
        return c;
    }

    public boolean isAscendingSortOrder() {
        Object attribute = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "sort-order");
        return !Boolean.FALSE.equals(attribute);
    }

    public void setAscendingSortOrder(Boolean order) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "sort-order", order);
    }
}

