/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabHeader;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabSummaryHeader;
import org.pentaho.reporting.engine.classic.core.CrosstabTitleHeader;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.CrosstabRowGroupType;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;

public class CrosstabRowGroup
extends Group {
    private CrosstabTitleHeader titleHeader;
    private CrosstabHeader header;
    private CrosstabSummaryHeader summaryHeader;

    public CrosstabRowGroup() {
        this.init();
    }

    private void init() {
        this.setElementType(new CrosstabRowGroupType());
        this.titleHeader = new CrosstabTitleHeader();
        this.header = new CrosstabHeader();
        this.summaryHeader = new CrosstabSummaryHeader();
        this.registerAsChild(this.titleHeader);
        this.registerAsChild(this.header);
        this.registerAsChild(this.summaryHeader);
    }

    public CrosstabRowGroup(GroupBody body) {
        super(body);
        this.validateBody(body);
        this.init();
    }

    public CrosstabRowGroup(CrosstabCellBody body) {
        super(body);
        this.init();
    }

    public CrosstabRowGroup(CrosstabColumnGroupBody body) {
        super(body);
        this.init();
    }

    public CrosstabTitleHeader getTitleHeader() {
        return this.titleHeader;
    }

    public void setTitleHeader(CrosstabTitleHeader titleHeader) {
        if (titleHeader == null) {
            throw new NullPointerException("titleHeader must not be null");
        }
        this.validateLooping(titleHeader);
        if (this.unregisterParent(titleHeader)) {
            return;
        }
        CrosstabTitleHeader element = this.titleHeader;
        this.titleHeader.setParent(null);
        this.titleHeader = titleHeader;
        this.titleHeader.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.titleHeader);
    }

    public CrosstabHeader getHeader() {
        return this.header;
    }

    public void setHeader(CrosstabHeader titleFooter) {
        if (titleFooter == null) {
            throw new NullPointerException("titleFooter must not be null");
        }
        this.validateLooping(titleFooter);
        if (this.unregisterParent(titleFooter)) {
            return;
        }
        CrosstabHeader element = this.header;
        this.header.setParent(null);
        this.header = titleFooter;
        this.header.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.header);
    }

    public CrosstabSummaryHeader getSummaryHeader() {
        return this.summaryHeader;
    }

    public void setSummaryHeader(CrosstabSummaryHeader summaryHeader) {
        if (summaryHeader == null) {
            throw new NullPointerException("summaryHeader must not be null");
        }
        this.validateLooping(summaryHeader);
        if (this.unregisterParent(summaryHeader)) {
            return;
        }
        CrosstabSummaryHeader element = this.summaryHeader;
        this.summaryHeader.setParent(null);
        this.summaryHeader = summaryHeader;
        this.summaryHeader.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.summaryHeader);
    }

    public String getField() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void setField(String field) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", field);
        this.notifyNodePropertiesChanged();
    }

    @Override
    protected GroupBody createDefaultBody() {
        return new CrosstabColumnGroupBody();
    }

    @Override
    public void setBody(GroupBody body) {
        this.validateBody(body);
        super.setBody(body);
    }

    private void validateBody(GroupBody body) {
        if (!(body instanceof CrosstabRowGroupBody) && !(body instanceof CrosstabColumnGroupBody)) {
            throw new IllegalArgumentException(body + " must be either row-group- or column-group-body");
        }
    }

    @Override
    public boolean isGroupChange(DataRow dataRow) {
        String field = this.getField();
        if (field == null) {
            return false;
        }
        return dataRow.isChanged(field);
    }

    @Override
    public CrosstabRowGroup clone() {
        CrosstabRowGroup element = (CrosstabRowGroup)super.clone();
        element.summaryHeader = (CrosstabSummaryHeader)this.summaryHeader.clone();
        element.titleHeader = (CrosstabTitleHeader)this.titleHeader.clone();
        element.header = (CrosstabHeader)this.header.clone();
        element.registerAsChild(element.titleHeader);
        element.registerAsChild(element.header);
        element.registerAsChild(element.summaryHeader);
        return element;
    }

    @Override
    public CrosstabRowGroup derive(boolean preserveElementInstanceIds) {
        CrosstabRowGroup element = (CrosstabRowGroup)super.derive(preserveElementInstanceIds);
        element.summaryHeader = (CrosstabSummaryHeader)this.summaryHeader.derive(preserveElementInstanceIds);
        element.titleHeader = (CrosstabTitleHeader)this.titleHeader.derive(preserveElementInstanceIds);
        element.header = (CrosstabHeader)this.header.derive(preserveElementInstanceIds);
        element.registerAsChild(element.titleHeader);
        element.registerAsChild(element.header);
        element.registerAsChild(element.summaryHeader);
        return element;
    }

    @Override
    public int getElementCount() {
        return 4;
    }

    @Override
    public Element getElement(int index) {
        switch (index) {
            case 0: {
                return this.getTitleHeader();
            }
            case 1: {
                return this.getHeader();
            }
            case 2: {
                return this.getSummaryHeader();
            }
            case 3: {
                return this.getBody();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setElementAt(int index, Element element) {
        switch (index) {
            case 0: {
                this.setTitleHeader((CrosstabTitleHeader)element);
                break;
            }
            case 1: {
                this.setHeader((CrosstabHeader)element);
                break;
            }
            case 2: {
                this.setSummaryHeader((CrosstabSummaryHeader)element);
                break;
            }
            case 3: {
                this.setBody((GroupBody)element);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    @Override
    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.titleHeader == element) {
            this.titleHeader.setParent(null);
            this.titleHeader = new CrosstabTitleHeader();
            this.titleHeader.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.titleHeader);
        } else if (this.summaryHeader == element) {
            this.summaryHeader.setParent(null);
            this.summaryHeader = new CrosstabSummaryHeader();
            this.summaryHeader.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.summaryHeader);
        } else if (this.header == element) {
            this.header.setParent(null);
            this.header = new CrosstabHeader();
            this.header.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.header);
        } else {
            super.removeElement(element);
        }
    }

    public boolean isPrintSummary() {
        Object attribute = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-summary");
        if (attribute == null) {
            return true;
        }
        return Boolean.TRUE.equals(attribute);
    }

    public void setPrintSummary(boolean printSummary) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-summary", printSummary);
    }

    @Override
    public List<SortConstraint> getSortingConstraint() {
        return this.mapFields(Collections.singletonList(this.getField()));
    }
}

