/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactorySupport;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataFactoryDesignTimeSupport;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.LinkedMap;

public class CompoundDataFactory
extends AbstractDataFactory
implements CompoundDataFactorySupport {
    private ArrayList<DataFactory> dataFactories = new ArrayList();

    @Override
    public void initialize(DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        super.initialize(dataFactoryContext);
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            dataFactory.initialize(dataFactoryContext);
        }
    }

    @Override
    public final TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        ArgumentNullException.validate((String)"query", (Object)query);
        ArgumentNullException.validate((String)"parameters", (Object)parameters);
        TableModel staticResult = this.queryStatic(query, parameters);
        if (staticResult != null) {
            return staticResult;
        }
        TableModel freeFormResult = this.queryFreeForm(query, parameters);
        if (freeFormResult != null) {
            return freeFormResult;
        }
        return this.handleFallThrough(query);
    }

    @Override
    public TableModel queryDesignTimeStructureFreeForm(String query, DataRow parameters) throws ReportDataFactoryException {
        return this.postProcess(query, parameters, this.queryDesignTimeStructFreeFormInternal(query, parameters));
    }

    private TableModel queryDesignTimeStructFreeFormInternal(String query, DataRow parameters) throws ReportDataFactoryException {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            if (dataFactory instanceof CompoundDataFactorySupport) {
                CompoundDataFactorySupport support = (CompoundDataFactorySupport)dataFactory;
                if (!support.isFreeFormQueryExecutable(query, parameters)) continue;
                return support.queryDesignTimeStructureFreeForm(query, parameters);
            }
            if (!this.isFreeFormQueryDataFactory(dataFactory) || !dataFactory.isQueryExecutable(query, parameters)) continue;
            if (dataFactory instanceof DataFactoryDesignTimeSupport) {
                DataFactoryDesignTimeSupport dts = (DataFactoryDesignTimeSupport)dataFactory;
                return dts.queryDesignTimeStructure(query, parameters);
            }
            return dataFactory.queryData(query, new AbstractDataFactory.DataRowWrapper(parameters));
        }
        return null;
    }

    @Override
    public TableModel queryFreeForm(String query, DataRow parameters) throws ReportDataFactoryException {
        return this.postProcess(query, parameters, this.queryFreeFormInternal(query, parameters));
    }

    private TableModel queryFreeFormInternal(String query, DataRow parameters) throws ReportDataFactoryException {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            if (dataFactory instanceof CompoundDataFactorySupport) {
                CompoundDataFactorySupport support = (CompoundDataFactorySupport)dataFactory;
                if (!support.isFreeFormQueryExecutable(query, parameters)) continue;
                return support.queryFreeForm(query, parameters);
            }
            if (!this.isFreeFormQueryDataFactory(dataFactory) || !dataFactory.isQueryExecutable(query, parameters)) continue;
            return dataFactory.queryData(query, parameters);
        }
        return null;
    }

    @Override
    public TableModel queryDesignTimeStructureStatic(String query, DataRow parameters) throws ReportDataFactoryException {
        return this.postProcess(query, parameters, this.queryDesignTimeStructStaticInternal(query, parameters));
    }

    private TableModel queryDesignTimeStructStaticInternal(String query, DataRow parameters) throws ReportDataFactoryException {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            if (dataFactory instanceof CompoundDataFactorySupport) {
                CompoundDataFactorySupport support = (CompoundDataFactorySupport)dataFactory;
                if (!support.isStaticQueryExecutable(query, parameters)) continue;
                return support.queryDesignTimeStructureStatic(query, parameters);
            }
            if (this.isFreeFormQueryDataFactory(dataFactory) || !dataFactory.isQueryExecutable(query, parameters)) continue;
            if (dataFactory instanceof DataFactoryDesignTimeSupport) {
                DataFactoryDesignTimeSupport dts = (DataFactoryDesignTimeSupport)dataFactory;
                return dts.queryDesignTimeStructure(query, parameters);
            }
            return dataFactory.queryData(query, new AbstractDataFactory.DataRowWrapper(parameters));
        }
        return null;
    }

    @Override
    public TableModel queryStatic(String query, DataRow parameters) throws ReportDataFactoryException {
        return this.postProcess(query, parameters, this.queryStaticInternal(query, parameters));
    }

    protected TableModel postProcess(String query, DataRow parameters, TableModel tableModel) {
        return tableModel;
    }

    private TableModel queryStaticInternal(String query, DataRow parameters) throws ReportDataFactoryException {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            if (dataFactory instanceof CompoundDataFactorySupport) {
                CompoundDataFactorySupport support = (CompoundDataFactorySupport)dataFactory;
                if (!support.isStaticQueryExecutable(query, parameters)) continue;
                return support.queryStatic(query, parameters);
            }
            if (this.isFreeFormQueryDataFactory(dataFactory) || !dataFactory.isQueryExecutable(query, parameters)) continue;
            return dataFactory.queryData(query, parameters);
        }
        return null;
    }

    @Override
    public TableModel queryDesignTimeStructure(String query, DataRow parameters) throws ReportDataFactoryException {
        ArgumentNullException.validate((String)"query", (Object)query);
        ArgumentNullException.validate((String)"parameters", (Object)parameters);
        TableModel staticResult = this.queryStatic(query, parameters);
        if (staticResult != null) {
            return staticResult;
        }
        TableModel freeFormResult = this.queryFreeForm(query, parameters);
        if (freeFormResult != null) {
            return freeFormResult;
        }
        return this.handleFallThrough(query);
    }

    protected TableModel handleFallThrough(String query) throws ReportDataFactoryException {
        throw new ReportDataFactoryException("None of the data-factories was able to handle this query.");
    }

    private boolean isFreeFormQueryDataFactory(DataFactory dataFactory) {
        DataFactoryMetaData metaData = dataFactory.getMetaData();
        return metaData.isFreeFormQuery();
    }

    @Override
    public DataFactory derive() {
        CompoundDataFactory cdf = this.deriveEmpty();
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            cdf.dataFactories.add(dataFactory.derive());
        }
        return cdf;
    }

    public CompoundDataFactory deriveEmpty() {
        CompoundDataFactory cdf = (CompoundDataFactory)this.clone();
        cdf.dataFactories = (ArrayList)this.dataFactories.clone();
        cdf.dataFactories.clear();
        return cdf;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            dataFactory.close();
        }
    }

    @Override
    public final boolean isQueryExecutable(String query, DataRow parameters) {
        return this.isStaticQueryExecutable(query, parameters) || this.isFreeFormQueryExecutable(query, parameters);
    }

    @Override
    public boolean isFreeFormQueryExecutable(String query, DataRow parameters) {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            CompoundDataFactorySupport support;
            DataFactory dataFactory = this.dataFactories.get(i);
            if (!(dataFactory instanceof CompoundDataFactorySupport ? (support = (CompoundDataFactorySupport)dataFactory).isFreeFormQueryExecutable(query, parameters) : this.isFreeFormQueryDataFactory(dataFactory) && dataFactory.isQueryExecutable(query, parameters))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStaticQueryExecutable(String query, DataRow parameters) {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            CompoundDataFactorySupport support;
            DataFactory dataFactory = this.dataFactories.get(i);
            if (!(dataFactory instanceof CompoundDataFactorySupport ? (support = (CompoundDataFactorySupport)dataFactory).isStaticQueryExecutable(query, parameters) : !this.isFreeFormQueryDataFactory(dataFactory) && dataFactory.isQueryExecutable(query, parameters))) continue;
            return true;
        }
        return false;
    }

    protected void addRaw(DataFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.dataFactories.add(factory);
    }

    public void add(DataFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        DataFactory derived = factory.derive();
        if (derived == null) {
            throw new IllegalStateException("Deriving failed silently. Fix your implementation of " + factory.getClass());
        }
        this.dataFactories.add(derived);
    }

    public void add(int index, DataFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        DataFactory derived = factory.derive();
        if (derived == null) {
            throw new InvalidReportStateException("Deriving failed silently. Fix your implementation of " + factory.getClass());
        }
        this.dataFactories.add(index, derived);
    }

    public void set(int index, DataFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        DataFactory derived = factory.derive();
        if (derived == null) {
            throw new InvalidReportStateException("Deriving failed silently. Fix your implementation of " + factory.getClass());
        }
        this.dataFactories.set(index, derived);
    }

    public void remove(int index) {
        this.dataFactories.remove(index);
    }

    public void remove(DataFactory dataFactory) {
        this.dataFactories.remove(dataFactory);
    }

    public int size() {
        return this.dataFactories.size();
    }

    public DataFactory get(int idx) {
        DataFactory df = this.dataFactories.get(idx);
        return df.derive();
    }

    public int indexOfByReference(DataFactory d) {
        for (int i = 0; i < this.size(); ++i) {
            DataFactory df = this.getReference(i);
            if (df != d) continue;
            return i;
        }
        return -1;
    }

    public DataFactory getReference(int idx) {
        return this.dataFactories.get(idx);
    }

    public boolean isNormalized() {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            if (!(dataFactory instanceof CompoundDataFactory)) continue;
            return false;
        }
        return true;
    }

    public static CompoundDataFactory normalize(DataFactory dataFactory) {
        return CompoundDataFactory.normalize(dataFactory, true);
    }

    protected CompoundDataFactory normalizeInternal(boolean derive) {
        CompoundDataFactory retval = this.deriveEmpty();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            DataFactory original = this.getReference(i);
            if (original instanceof CompoundDataFactory) {
                CompoundDataFactory container = CompoundDataFactory.normalize(original, derive);
                int containerSize = container.size();
                for (int x = 0; x < containerSize; ++x) {
                    if (derive) {
                        retval.add(container.getReference(x));
                        continue;
                    }
                    retval.addRaw(container.getReference(x));
                }
                continue;
            }
            if (derive) {
                retval.add(original);
                continue;
            }
            retval.addRaw(original);
        }
        return retval;
    }

    public static CompoundDataFactory normalize(DataFactory dataFactory, boolean derive) {
        if (dataFactory == null) {
            return new CompoundDataFactory();
        }
        if (!(dataFactory instanceof CompoundDataFactory)) {
            CompoundDataFactory retval = new CompoundDataFactory();
            if (derive) {
                retval.add(dataFactory);
            } else {
                retval.addRaw(dataFactory);
            }
            return retval;
        }
        CompoundDataFactory cdf = (CompoundDataFactory)dataFactory;
        if (cdf.isNormalized()) {
            if (derive) {
                return (CompoundDataFactory)cdf.derive();
            }
            return cdf;
        }
        return cdf.normalizeInternal(derive);
    }

    @Override
    public String[] getQueryNames() {
        LinkedMap nameSet = new LinkedMap();
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            String[] queryNames = dataFactory.getQueryNames();
            for (int j = 0; j < queryNames.length; ++j) {
                String queryName = queryNames[j];
                nameSet.put((Object)queryName, (Object)queryName);
            }
        }
        return (String[])nameSet.keys((Object[])new String[nameSet.size()]);
    }

    @Override
    public DataFactory getDataFactoryForQuery(String queryName, boolean freeform) {
        StaticDataRow dr = new StaticDataRow();
        for (int i = 0; i < this.size(); ++i) {
            CompoundDataFactorySupport cdf;
            DataFactory r;
            DataFactory df = this.dataFactories.get(i);
            if (df instanceof CompoundDataFactorySupport && (r = (cdf = (CompoundDataFactorySupport)df).getDataFactoryForQuery(queryName, freeform)) != null) {
                return r;
            }
            if (this.isFreeFormQueryDataFactory(df) != freeform || !df.isQueryExecutable(queryName, dr)) continue;
            return df;
        }
        return null;
    }

    public DataFactory getDataFactoryForQuery(String queryName) {
        DataFactory nonFreeForm = this.getDataFactoryForQuery(queryName, false);
        if (nonFreeForm != null) {
            return nonFreeForm;
        }
        DataFactory freeForm = this.getDataFactoryForQuery(queryName, true);
        if (freeForm != null) {
            return freeForm;
        }
        return null;
    }
}

