/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.bitmap.DIBReader;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdDibBitBlt
extends MfCmd {
    private static final int RECORD_SIZE_SIMPLE = 9;
    private static final int RECORD_BASE_SIZE_EXT = 8;
    private static final int POS_OPERATION = 0;
    private static final int POS_SRC_Y = 2;
    private static final int POS_SRC_X = 3;
    private static final int SIMPLE_POS_HEIGHT = 5;
    private static final int SIMPLE_POS_WIDTH = 6;
    private static final int SIMPLE_POS_DST_Y = 7;
    private static final int SIMPLE_POS_DST_X = 8;
    private static final int EXT_POS_HEIGHT = 4;
    private static final int EXT_POS_WIDTH = 5;
    private static final int EXT_POS_DST_Y = 6;
    private static final int EXT_POS_DST_X = 7;
    private BufferedImage image;
    private int scaled_destX;
    private int scaled_destY;
    private int scaled_destWidth;
    private int scaled_destHeight;
    private int scaled_sourceX;
    private int scaled_sourceY;
    private int destX;
    private int destY;
    private int destWidth;
    private int destHeight;
    private int sourceX;
    private int sourceY;
    private int operation;

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @Override
    public void replay(WmfFile file) {
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[DIB_BIT_BLT] records=");
        b.append(this.getOperation());
        b.append(" source=");
        b.append(this.getOrigin());
        b.append(" destination=");
        b.append(this.getDestination());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_sourceX = this.getScaledX(this.sourceX);
        this.scaled_destX = this.getScaledX(this.destX);
        this.scaled_destWidth = this.getScaledX(this.destWidth);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_sourceY = this.getScaledY(this.sourceY);
        this.scaled_destY = this.getScaledY(this.destY);
        this.scaled_destHeight = this.getScaledY(this.destHeight);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdDibBitBlt();
    }

    @Override
    public int getFunction() {
        return 2368;
    }

    public void setOrigin(int x, int y) {
        this.sourceX = x;
        this.sourceY = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Point getOrigin() {
        return new Point(this.sourceX, this.sourceY);
    }

    public Rectangle getSource() {
        return new Rectangle(this.sourceX, this.sourceY, this.destWidth, this.destHeight);
    }

    public Point getScaledOrigin() {
        return new Point(this.scaled_sourceX, this.scaled_sourceY);
    }

    public Rectangle getScaledSource() {
        return new Rectangle(this.scaled_sourceX, this.scaled_sourceY, this.scaled_destWidth, this.scaled_destHeight);
    }

    public void setDestination(int x, int y, int w, int h) {
        this.destX = x;
        this.destY = y;
        this.destWidth = w;
        this.destHeight = h;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Rectangle getDestination() {
        return new Rectangle(this.destX, this.destY, this.destWidth, this.destHeight);
    }

    public Rectangle getScaledDestination() {
        return new Rectangle(this.scaled_destX, this.scaled_destY, this.scaled_destWidth, this.scaled_destHeight);
    }

    public void setOperation(int op) {
        this.operation = op;
    }

    public int getOperation() {
        return this.operation;
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        if (this.image == null) {
            MfRecord record = new MfRecord(9);
            record.setLongParam(0, this.getOperation());
            Rectangle source = this.getSource();
            record.setParam(2, (int)source.getY());
            record.setParam(3, (int)source.getX());
            Rectangle dest = this.getDestination();
            record.setParam(4, 0);
            record.setParam(5, (int)dest.getHeight());
            record.setParam(6, (int)dest.getWidth());
            record.setParam(7, (int)dest.getY());
            record.setParam(8, (int)dest.getX());
            return record;
        }
        throw new RecordCreationException("The extended Format of DibBitBlt is not supported");
    }

    @Override
    public void setRecord(MfRecord record) {
        int rop = record.getLongParam(0);
        int sy = record.getParam(2);
        int sx = record.getParam(3);
        this.setOperation(rop);
        this.setOrigin(sx, sy);
        if (record.getLength() == 22) {
            int dh = record.getParam(5);
            int dw = record.getParam(6);
            int dy = record.getParam(7);
            int dx = record.getParam(8);
            this.setDestination(dx, dy, dw, dh);
        } else {
            int dh = record.getParam(4);
            int dw = record.getParam(5);
            int dy = record.getParam(6);
            int dx = record.getParam(7);
            this.setDestination(dx, dy, dw, dh);
            try {
                DIBReader reader = new DIBReader();
                this.setImage(reader.setRecord(record, 8));
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

