/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.component;

import org.mortbay.component.LifeCycle;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private Object _lock = new Object();
    private final int FAILED = -1;
    private final int STOPPED = 0;
    private final int STARTING = 1;
    private final int STARTED = 2;
    private final int STOPPING = 3;
    private volatile int _state = 0;
    protected LifeCycle.Listener[] _listeners;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (this._state == 2 || this._state == 1) {
                    return;
                }
                this.setStarting();
                this.doStart();
                Log.debug("started {}", this);
                this.setStarted();
            }
            catch (Exception e) {
                this.setFailed(e);
                throw e;
            }
            catch (Error e) {
                this.setFailed(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (this._state == 3 || this._state == 0) {
                    return;
                }
                this.setStopping();
                this.doStop();
                Log.debug("stopped {}", this);
                this.setStopped();
            }
            catch (Exception e) {
                this.setFailed(e);
                throw e;
            }
            catch (Error e) {
                this.setFailed(e);
                throw e;
            }
        }
    }

    public boolean isRunning() {
        int localState = this._state;
        return localState == 2 || localState == 1;
    }

    public boolean isStarted() {
        return this._state == 2;
    }

    public boolean isStarting() {
        return this._state == 1;
    }

    public boolean isStopping() {
        return this._state == 3;
    }

    public boolean isStopped() {
        return this._state == 0;
    }

    public boolean isFailed() {
        return this._state == -1;
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this._listeners = (LifeCycle.Listener[])LazyList.addToArray(this._listeners, listener, LifeCycle.Listener.class);
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this._listeners = (LifeCycle.Listener[])LazyList.removeFromArray(this._listeners, listener);
    }

    private void setStarted() {
        this._state = 2;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleStarted(this);
            }
        }
    }

    private void setStarting() {
        this._state = 1;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleStarting(this);
            }
        }
    }

    private void setStopping() {
        this._state = 3;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleStopping(this);
            }
        }
    }

    private void setStopped() {
        this._state = 0;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleStopped(this);
            }
        }
    }

    private void setFailed(Throwable th) {
        Log.warn("failed " + this + ": " + th);
        Log.debug(th);
        this._state = -1;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleFailure(this, th);
            }
        }
    }
}

