/*
 * Decompiled with CFR 0.152.
 */
package net.sf.farrago.jdbc.client;

import de.simplicit.vjdbc.VirtualDriver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.farrago.jdbc.FarragoAbstractJdbcDriver;
import net.sf.farrago.release.FarragoReleaseProperties;

public abstract class FarragoUnregisteredVjdbcClientDriver
extends FarragoAbstractJdbcDriver {
    @Override
    public String getUrlPrefix() {
        return this.getBaseUrl() + "rmi://";
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        VirtualDriver rmiDriver;
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties driverProps = this.applyDefaultConnectionProps(info);
        String driverUrl = this.parseConnectionParams(url, driverProps);
        try {
            rmiDriver = new VirtualDriver();
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
        String urlRmi = driverUrl.substring(this.getUrlPrefix().length());
        String[] split = urlRmi.split(":");
        if (split.length == 1) {
            FarragoReleaseProperties props = FarragoReleaseProperties.instance();
            urlRmi = urlRmi + ":" + props.jdbcUrlPortDefault.get();
        }
        urlRmi = "jdbc:vjdbc:rmi://" + urlRmi + "/VJdbc,FarragoDBMS";
        return rmiDriver.connect(urlRmi, driverProps);
    }
}

