/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;
import org.pentaho.plugin.jfreereport.reportcharts.AbstractChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaPieTooltipGenerator;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaPieURLGenerator;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;

public class PieChartExpression
extends AbstractChartExpression {
    private static final int EXPLODE_VALUE = 0;
    private static final int EXPLODE_MIN = 1;
    private static final int EXPLODE_MAX = 2;
    private static final long serialVersionUID = 5755617219149952355L;
    private boolean rotationClockwise = true;
    private String explodeSegment;
    private Double explodePct;
    private boolean ignoreNulls = true;
    private boolean ignoreZeros = true;
    private String pieLabelFormat = "{2}";
    private boolean circular = true;
    private String pieLegendLabelFormat = "{0}";
    private Color shadowPaint;
    private Double shadowXOffset;
    private Double shadowYOffset;

    public PieChartExpression() {
        this.setItemsLabelVisible(Boolean.TRUE);
    }

    public Color getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Color shadowPaint) {
        this.shadowPaint = shadowPaint;
    }

    public Double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(Double shadowXOffset) {
        this.shadowXOffset = shadowXOffset;
    }

    public Double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(Double shadowYOffset) {
        this.shadowYOffset = shadowYOffset;
    }

    public boolean isRotationClockwise() {
        return this.rotationClockwise;
    }

    public void setRotationClockwise(boolean value) {
        this.rotationClockwise = value;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean value) {
        this.ignoreNulls = value;
    }

    public boolean isIgnoreZeros() {
        return this.ignoreZeros;
    }

    public void setIgnoreZeros(boolean value) {
        this.ignoreZeros = value;
    }

    public String getExplodeSegment() {
        return this.explodeSegment;
    }

    public void setExplodeSegment(String value) {
        this.explodeSegment = value;
    }

    public Double getExplodePct() {
        return this.explodePct;
    }

    public void setExplodePct(Double value) {
        this.explodePct = value;
    }

    public String getPieLabelFormat() {
        return this.pieLabelFormat;
    }

    public void setPieLabelFormat(String value) {
        this.pieLabelFormat = value;
    }

    public String getPieLegendLabelFormat() {
        return this.pieLegendLabelFormat;
    }

    public void setPieLegendLabelFormat(String value) {
        this.pieLegendLabelFormat = value;
    }

    public boolean getIsCircular() {
        return this.circular;
    }

    public void setCircular(boolean value) {
        this.circular = value;
    }

    @Override
    protected JFreeChart computeChart(Dataset dataset) {
        PieDataset pieDataset = null;
        if (dataset instanceof PieDataset) {
            pieDataset = (PieDataset)dataset;
        }
        if (this.isThreeD()) {
            return ChartFactory.createPieChart3D((String)this.computeTitle(), (PieDataset)pieDataset, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        }
        return ChartFactory.createPieChart((String)this.computeTitle(), (PieDataset)pieDataset, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
    }

    protected void configureExplode(PiePlot pp) {
        PieDataset pieDS = pp.getDataset();
        int explodeType = this.computeExplodeType();
        if (explodeType == 0) {
            try {
                int actualSegment = Integer.parseInt(this.explodeSegment);
                if (actualSegment >= 0) {
                    pp.setExplodePercent(pieDS.getKey(actualSegment), this.explodePct.doubleValue());
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            return;
        }
        if (pieDS != null) {
            int itemCount = pieDS.getItemCount();
            Number maxNum = new Double(-2.147483648E9);
            Number minNum = new Double(2.147483647E9);
            int maxSegment = -1;
            int minSegment = -1;
            for (int i = 0; i < itemCount; ++i) {
                Number nbr = pieDS.getValue(i);
                if (nbr.doubleValue() > maxNum) {
                    maxNum = nbr;
                    maxSegment = i;
                }
                if (!(nbr.doubleValue() < minNum)) continue;
                minNum = nbr;
                minSegment = i;
            }
            if (explodeType == 1) {
                if (minSegment >= 0) {
                    pp.setExplodePercent(pieDS.getKey(minSegment), this.explodePct.doubleValue());
                }
            } else if (maxSegment >= 0) {
                pp.setExplodePercent(pieDS.getKey(maxSegment), this.explodePct.doubleValue());
            }
        }
    }

    private int computeExplodeType() {
        if ("minValue".equals(this.explodeSegment)) {
            return 1;
        }
        if ("maxValue".equals(this.explodeSegment)) {
            return 2;
        }
        return 0;
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        super.configureChart(chart);
        Plot plot = chart.getPlot();
        PiePlot pp = (PiePlot)plot;
        PieDataset pieDS = pp.getDataset();
        pp.setDirection(this.rotationClockwise ? Rotation.CLOCKWISE : Rotation.ANTICLOCKWISE);
        if (this.explodeSegment != null && this.explodePct != null) {
            this.configureExplode(pp);
        }
        if (!StringUtils.isEmpty((String)this.getTooltipFormula())) {
            pp.setToolTipGenerator((PieToolTipGenerator)new FormulaPieTooltipGenerator(this.getRuntime(), this.getTooltipFormula()));
        }
        if (!StringUtils.isEmpty((String)this.getUrlFormula())) {
            pp.setURLGenerator((PieURLGenerator)new FormulaPieURLGenerator(this.getRuntime(), this.getUrlFormula()));
        }
        pp.setIgnoreNullValues(this.ignoreNulls);
        pp.setIgnoreZeroValues(this.ignoreZeros);
        if (Boolean.FALSE.equals(this.getItemsLabelVisible())) {
            pp.setLabelGenerator(null);
        } else {
            ExpressionRuntime runtime = this.getRuntime();
            Locale locale = runtime.getResourceBundleFactory().getLocale();
            FastDecimalFormat fastPercent = new FastDecimalFormat(3, locale);
            FastDecimalFormat fastInteger = new FastDecimalFormat(1, locale);
            DecimalFormat numFormat = new DecimalFormat(fastInteger.getPattern(), new DecimalFormatSymbols(locale));
            numFormat.setRoundingMode(RoundingMode.HALF_UP);
            DecimalFormat percentFormat = new DecimalFormat(fastPercent.getPattern(), new DecimalFormatSymbols(locale));
            percentFormat.setRoundingMode(RoundingMode.HALF_UP);
            StandardPieSectionLabelGenerator labelGen = new StandardPieSectionLabelGenerator(this.pieLabelFormat, (NumberFormat)numFormat, (NumberFormat)percentFormat);
            pp.setLabelGenerator((PieSectionLabelGenerator)labelGen);
            StandardPieSectionLabelGenerator legendGen = new StandardPieSectionLabelGenerator(this.pieLegendLabelFormat, (NumberFormat)numFormat, (NumberFormat)percentFormat);
            pp.setLegendLabelGenerator((PieSectionLabelGenerator)legendGen);
        }
        if (!StringUtils.isEmpty((String)this.getLabelFont())) {
            pp.setLabelFont(Font.decode(this.getLabelFont()));
        }
        if (pieDS != null) {
            String[] colors = this.getSeriesColor();
            for (int i = 0; i < colors.length && i < pieDS.getItemCount(); ++i) {
                pp.setSectionPaint(pieDS.getKey(i), (Paint)this.parseColorFromString(colors[i]));
            }
        }
        if (this.shadowPaint != null) {
            pp.setShadowPaint((Paint)this.shadowPaint);
        }
        if (this.shadowXOffset != null) {
            pp.setShadowXOffset(this.shadowXOffset.doubleValue());
        }
        if (this.shadowYOffset != null) {
            pp.setShadowYOffset(this.shadowYOffset.doubleValue());
        }
        pp.setCircular(this.circular);
        if (!this.isShowBorder() || !this.isChartSectionOutline()) {
            chart.setBorderVisible(false);
            chart.getPlot().setOutlineVisible(false);
        }
    }
}

