/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.VersionSelector;
import org.apache.jackrabbit.spi.Name;

public class DateVersionSelector
implements VersionSelector {
    private Calendar date = null;
    private boolean returnLatest = false;

    public DateVersionSelector(Calendar date) {
        this.date = date;
    }

    public DateVersionSelector(Calendar date, boolean returnLatest) {
        this.date = date;
        this.returnLatest = returnLatest;
    }

    public Calendar getDate() {
        return this.date;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public boolean isReturnLatest() {
        return this.returnLatest;
    }

    public void setReturnLatest(boolean returnLatest) {
        this.returnLatest = returnLatest;
    }

    public InternalVersion select(InternalVersionHistory versionHistory) throws RepositoryException {
        InternalVersion selected = null;
        if (this.date != null) {
            selected = DateVersionSelector.selectByDate(versionHistory, this.date);
        }
        if (selected == null && this.returnLatest) {
            selected = DateVersionSelector.selectByDate(versionHistory, null);
        }
        return selected;
    }

    public static InternalVersion selectByDate(InternalVersionHistory history, Calendar date) throws RepositoryException {
        long time = date != null ? date.getTimeInMillis() : Long.MAX_VALUE;
        long latestDate = Long.MIN_VALUE;
        InternalVersion latestVersion = null;
        for (Name name : history.getVersionNames()) {
            long c;
            InternalVersion v = history.getVersion(name);
            if (v.isRootVersion() || (c = v.getCreated().getTimeInMillis()) <= latestDate || c > time) continue;
            latestDate = c;
            latestVersion = v;
        }
        return latestVersion;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("DateVersionSelector(");
        ret.append("date=");
        ret.append(this.date);
        ret.append(", returnLatest=");
        ret.append(this.returnLatest);
        ret.append(")");
        return ret.toString();
    }
}

