/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.stats;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.core.stats.TimeSeriesAverage;
import org.apache.jackrabbit.core.stats.TimeSeriesRecorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryStatisticsImpl
implements Iterable<Map.Entry<RepositoryStatistics.Type, TimeSeries>>,
RepositoryStatistics {
    private final Map<RepositoryStatistics.Type, TimeSeriesRecorder> recorders = new HashMap<RepositoryStatistics.Type, TimeSeriesRecorder>();
    private final Map<RepositoryStatistics.Type, TimeSeriesAverage> avg = new HashMap<RepositoryStatistics.Type, TimeSeriesAverage>();

    public RepositoryStatisticsImpl() {
        this.getOrCreateRecorder(RepositoryStatistics.Type.SESSION_COUNT);
        this.getOrCreateRecorder(RepositoryStatistics.Type.SESSION_LOGIN_COUNTER);
        this.createAvg(RepositoryStatistics.Type.SESSION_READ_COUNTER, RepositoryStatistics.Type.SESSION_READ_DURATION, RepositoryStatistics.Type.SESSION_READ_AVERAGE);
        this.createAvg(RepositoryStatistics.Type.SESSION_WRITE_COUNTER, RepositoryStatistics.Type.SESSION_WRITE_DURATION, RepositoryStatistics.Type.SESSION_WRITE_AVERAGE);
        this.createAvg(RepositoryStatistics.Type.BUNDLE_CACHE_MISS_COUNTER, RepositoryStatistics.Type.BUNDLE_CACHE_MISS_DURATION, RepositoryStatistics.Type.BUNDLE_CACHE_MISS_AVERAGE);
        this.createAvg(RepositoryStatistics.Type.BUNDLE_WRITE_COUNTER, RepositoryStatistics.Type.BUNDLE_WRITE_DURATION, RepositoryStatistics.Type.BUNDLE_WRITE_AVERAGE);
        this.createAvg(RepositoryStatistics.Type.QUERY_COUNT, RepositoryStatistics.Type.QUERY_DURATION, RepositoryStatistics.Type.QUERY_AVERAGE);
    }

    private void createAvg(RepositoryStatistics.Type count, RepositoryStatistics.Type duration, RepositoryStatistics.Type avgTs) {
        this.avg.put(avgTs, new TimeSeriesAverage(this.getOrCreateRecorder(duration), this.getOrCreateRecorder(count)));
    }

    public RepositoryStatisticsImpl(ScheduledExecutorService executor) {
        this();
        executor.scheduleAtFixedRate(new Runnable(){

            public void run() {
                RepositoryStatisticsImpl.this.recordOneSecond();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public synchronized Iterator<Map.Entry<RepositoryStatistics.Type, TimeSeries>> iterator() {
        TreeMap<RepositoryStatistics.Type, Object> map = new TreeMap<RepositoryStatistics.Type, Object>();
        map.putAll(this.recorders);
        map.putAll(this.avg);
        return map.entrySet().iterator();
    }

    public AtomicLong getCounter(RepositoryStatistics.Type type) {
        return this.getOrCreateRecorder(type).getCounter();
    }

    public TimeSeries getTimeSeries(RepositoryStatistics.Type type) {
        if (this.avg.containsKey(type)) {
            return this.avg.get(type);
        }
        return this.getOrCreateRecorder(type);
    }

    private synchronized TimeSeriesRecorder getOrCreateRecorder(RepositoryStatistics.Type type) {
        TimeSeriesRecorder recorder = this.recorders.get(type);
        if (recorder == null) {
            recorder = new TimeSeriesRecorder(type);
            this.recorders.put(type, recorder);
        }
        return recorder;
    }

    private synchronized void recordOneSecond() {
        for (TimeSeriesRecorder recorder : this.recorders.values()) {
            recorder.recordOneSecond();
        }
    }
}

