/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptedSimpleCredentials
implements Credentials {
    private static final Logger log = LoggerFactory.getLogger(CryptedSimpleCredentials.class);
    private final String algorithm;
    private final String salt;
    private final String hashedPassword;
    private final String userId;
    private final Map<String, Object> attributes;

    public CryptedSimpleCredentials(SimpleCredentials credentials) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.userId = credentials.getUserID();
        if (this.userId == null || this.userId.length() == 0) {
            throw new IllegalArgumentException();
        }
        char[] pwd = credentials.getPassword();
        if (pwd == null) {
            throw new IllegalArgumentException();
        }
        String password = new String(pwd);
        this.algorithm = "sha1";
        this.salt = null;
        this.hashedPassword = CryptedSimpleCredentials.generateHash(password, this.algorithm, this.salt);
        String[] attNames = credentials.getAttributeNames();
        this.attributes = new HashMap<String, Object>(attNames.length);
        for (String attName : attNames) {
            this.attributes.put(attName, credentials.getAttribute(attName));
        }
    }

    public CryptedSimpleCredentials(String userId, String hashedPassword) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("Invalid userID: The userID must have a length > 0.");
        }
        if (hashedPassword == null) {
            throw new IllegalArgumentException("Password may not be null.");
        }
        this.userId = userId;
        String algo = CryptedSimpleCredentials.extractAlgorithm(hashedPassword);
        if (algo == null) {
            log.debug("Plain text password -> Using sha1 to create digest.");
            this.algorithm = "sha1";
            this.salt = CryptedSimpleCredentials.generateSalt();
            this.hashedPassword = CryptedSimpleCredentials.generateHash(hashedPassword, this.algorithm, this.salt);
        } else {
            this.algorithm = algo;
            this.salt = CryptedSimpleCredentials.extractSalt(hashedPassword, this.algorithm);
            this.hashedPassword = hashedPassword;
        }
        this.attributes = Collections.emptyMap();
    }

    public String getUserID() {
        return this.userId;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getPassword() {
        return this.hashedPassword;
    }

    public boolean matches(SimpleCredentials credentials) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.getUserID().equalsIgnoreCase(credentials.getUserID())) {
            return this.hashedPassword.equals(CryptedSimpleCredentials.generateHash(String.valueOf(credentials.getPassword()), this.algorithm, this.salt));
        }
        return false;
    }

    public static String buildPasswordHash(String password) throws RepositoryException {
        try {
            return new CryptedSimpleCredentials("_", password).getPassword();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static String generateHash(String pwd, String algorithm, String salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuilder password = new StringBuilder();
        password.append("{").append(algorithm).append("}");
        if (salt != null && salt.length() > 0) {
            password.append(salt).append("-");
            StringBuilder data = new StringBuilder();
            data.append(salt).append(pwd);
            password.append(Text.digest((String)algorithm, (byte[])data.toString().getBytes("UTF-8")));
        } else {
            password.append(Text.digest((String)algorithm, (byte[])pwd.getBytes("UTF-8")));
        }
        return password.toString();
    }

    private static String extractAlgorithm(String hashedPwd) {
        int end = hashedPwd.indexOf(125);
        if (hashedPwd.startsWith("{") && end > 0) {
            String algorithm = hashedPwd.substring(1, end);
            try {
                MessageDigest.getInstance(algorithm);
                return algorithm;
            }
            catch (NoSuchAlgorithmException e) {
                log.debug("Invalid algorithm detected " + algorithm);
            }
        }
        return null;
    }

    private static String extractSalt(String hashedPwd, String algorithm) {
        int start = algorithm.length() + 2;
        int end = hashedPwd.indexOf(45, start);
        if (end > -1) {
            return hashedPwd.substring(start, end);
        }
        return null;
    }

    private static String generateSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        StringBuffer res = new StringBuffer(salt.length * 2);
        for (byte b : salt) {
            res.append(Text.hexTable[b >> 4 & 0xF]);
            res.append(Text.hexTable[b & 0xF]);
        }
        return res.toString();
    }
}

