/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.FieldComparatorBase;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldComparator
extends FieldComparatorBase {
    private final Comparable<?>[] values;
    protected final List<IndexReader> readers = new ArrayList<IndexReader>();
    protected int[] starts;

    protected AbstractFieldComparator(int numHits) {
        this.values = new Comparable[numHits];
    }

    protected final int readerIndex(int n) {
        int lo = 0;
        int hi = this.readers.size() - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.readers.size() && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    @Override
    public void setValue(int slot, Comparable<?> value) {
        this.values[slot] = value;
    }

    @Override
    public Comparable<?> getValue(int slot) {
        return this.values[slot];
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        AbstractFieldComparator.getIndexReaders(this.readers, reader);
        int maxDoc = 0;
        this.starts = new int[this.readers.size() + 1];
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader r = this.readers.get(i);
            this.starts[i] = maxDoc;
            maxDoc += r.maxDoc();
        }
        this.starts[this.readers.size()] = maxDoc;
    }

    private static void getIndexReaders(List<IndexReader> readers, IndexReader reader) {
        if (reader instanceof MultiIndexReader) {
            for (IndexReader r : ((MultiIndexReader)reader).getIndexReaders()) {
                AbstractFieldComparator.getIndexReaders(readers, r);
            }
        } else {
            readers.add(reader);
        }
    }

    protected String getUUIDForIndex(int doc) throws IOException {
        int idx = this.readerIndex(doc);
        IndexReader reader = this.readers.get(idx);
        Document document = reader.document(doc - this.starts[idx]);
        return document.get(FieldNames.UUID);
    }
}

