/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DecimalField;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.PropertyMetaData;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFieldCache {
    public static final SharedFieldCache INSTANCE = new SharedFieldCache();
    private final Map<IndexReader, Map<Key, ValueIndex>> cache = new WeakHashMap<IndexReader, Map<Key, ValueIndex>>();

    private SharedFieldCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueIndex getValueIndex(IndexReader reader, String field, String prefix) throws IOException {
        ValueIndex ret;
        if (reader instanceof ReadOnlyIndexReader) {
            reader = ((ReadOnlyIndexReader)reader).getBase();
        }
        if ((ret = this.lookup((IndexReader)reader, field = field.intern(), prefix)) == null) {
            int maxDocs = reader.maxDoc();
            Comparable[] retArray = new Comparable[maxDocs];
            HashMap<Integer, Integer> positions = new HashMap<Integer, Integer>();
            boolean usingSimpleComparable = true;
            int setValues = 0;
            if (maxDocs > 0) {
                TermPositions termDocs;
                IndexFormatVersion version = IndexFormatVersion.getVersion(reader);
                boolean hasPayloads = version.isAtLeast(IndexFormatVersion.V3);
                byte[] payload = null;
                if (hasPayloads) {
                    termDocs = reader.termPositions();
                    payload = new byte[1];
                } else {
                    termDocs = reader.termDocs();
                }
                TermEnum termEnum = reader.terms(new Term(field, prefix));
                try {
                    Term term;
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    while ((term = termEnum.term()).field() == field) {
                        if (!term.text().startsWith(prefix)) {
                        } else {
                            String value = SharedFieldCache.termValueAsString(term, prefix);
                            termDocs.seek(term);
                            while (termDocs.next()) {
                                int termPosition = 0;
                                int type = 0;
                                if (hasPayloads) {
                                    TermPositions termPos = termDocs;
                                    termPosition = termPos.nextPosition();
                                    if (termPos.isPayloadAvailable()) {
                                        payload = termPos.getPayload(payload, 0);
                                        type = PropertyMetaData.fromByteArray(payload).getPropertyType();
                                    }
                                }
                                ++setValues;
                                Comparable<?> v = this.getValue(value, type);
                                int doc = termDocs.doc();
                                Comparable ca = retArray[doc];
                                if (ca == null) {
                                    if (usingSimpleComparable) {
                                        positions.put(doc, termPosition);
                                        retArray[doc] = v;
                                        continue;
                                    }
                                    retArray[doc] = new ComparableArray(v, termPosition);
                                    continue;
                                }
                                if (ca instanceof ComparableArray) {
                                    ((ComparableArray)ca).insert(v, termPosition);
                                    continue;
                                }
                                Iterator i$ = positions.keySet().iterator();
                                while (i$.hasNext()) {
                                    int pos = (Integer)i$.next();
                                    retArray[pos] = new ComparableArray(retArray[pos], (Integer)positions.get(pos));
                                }
                                positions = null;
                                usingSimpleComparable = false;
                                ComparableArray caNew = (ComparableArray)retArray[doc];
                                retArray[doc] = caNew.insert(v, termPosition);
                            }
                            if (termEnum.next()) continue;
                        }
                        break;
                    }
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            ValueIndex value = new ValueIndex(retArray, setValues);
            this.store((IndexReader)reader, field, prefix, value);
            return value;
        }
        return ret;
    }

    private static String termValueAsString(Term term, String prefix) {
        String text = term.text();
        int length = text.length() - prefix.length();
        char[] tmp = new char[length];
        text.getChars(prefix.length(), text.length(), tmp, 0);
        return new String(tmp, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueIndex lookup(IndexReader reader, String field, String prefix) {
        Map<IndexReader, Map<Key, ValueIndex>> map = this.cache;
        synchronized (map) {
            Map<Key, ValueIndex> readerCache = this.cache.get(reader);
            if (readerCache == null) {
                return null;
            }
            return readerCache.get(new Key(field, prefix));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(IndexReader reader, String field, String prefix, ValueIndex value) {
        Map<IndexReader, Map<Key, ValueIndex>> map = this.cache;
        synchronized (map) {
            Map<Key, ValueIndex> readerCache = this.cache.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<Key, ValueIndex>();
                this.cache.put(reader, readerCache);
            }
            readerCache.put(new Key(field, prefix), value);
        }
    }

    private Comparable<?> getValue(String value, int type) {
        switch (type) {
            case 6: {
                return Boolean.valueOf(value);
            }
            case 5: {
                return DateField.stringToTime(value);
            }
            case 3: {
                return LongField.stringToLong(value);
            }
            case 4: {
                return DoubleField.stringToDouble(value);
            }
            case 12: {
                return DecimalField.stringToDecimal(value);
            }
        }
        return value;
    }

    static class Key {
        private final String field;
        private final String prefix;

        Key(String field, String prefix) {
            this.field = field.intern();
            this.prefix = prefix.intern();
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return other.field == this.field && other.prefix == this.prefix;
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.prefix.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComparableArray
    implements Comparable<ComparableArray> {
        private int offset = 0;
        private Comparable<?>[] c = new Comparable[0];

        public ComparableArray(Comparable<?> item, int index) {
            this.insert(item, index);
        }

        @Override
        public int compareTo(ComparableArray o) {
            return Util.compare(this.c, o.c);
        }

        int getOffset() {
            return this.offset;
        }

        public ComparableArray insert(Comparable<?> item, int index) {
            if (this.c.length == 0) {
                this.offset = index;
                this.c = new Comparable[]{item};
                return this;
            }
            if (index >= this.offset && index < this.offset + this.c.length) {
                this.c[index - this.offset] = item;
                return this;
            }
            if (index < this.offset) {
                int relativeOffset = this.offset - index;
                Comparable[] newC = new Comparable[relativeOffset + this.c.length];
                newC[0] = item;
                System.arraycopy(this.c, 0, newC, relativeOffset, this.c.length);
                this.c = newC;
                this.offset = index;
                return this;
            }
            if (index >= this.offset + this.c.length) {
                Comparable[] newC = new Comparable[index - this.offset + 1];
                System.arraycopy(this.c, 0, newC, 0, this.c.length);
                newC[index - this.offset] = item;
                this.c = newC;
                return this;
            }
            return this;
        }

        public String toString() {
            if (this.c == null) {
                return null;
            }
            if (this.c.length == 1) {
                return this.c[0].toString();
            }
            return Arrays.toString(this.c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueIndex {
        private static final int SPARSE_FACTOR = 100;
        private final Comparable<?>[] values;
        public final Map<Integer, Comparable<?>> valuesMap;
        public final boolean sparse;

        public ValueIndex(Comparable<?>[] values, int setValues) {
            if (ValueIndex.isSparse(values, setValues)) {
                this.sparse = true;
                this.values = null;
                this.valuesMap = setValues == 0 ? null : ValueIndex.getValuesMap(values, setValues);
            } else {
                this.sparse = false;
                this.values = values;
                this.valuesMap = null;
            }
        }

        public Comparable<?> getValue(int i) {
            if (this.sparse) {
                return this.valuesMap == null ? null : this.valuesMap.get(i);
            }
            return this.values[i];
        }

        private static Map<Integer, Comparable<?>> getValuesMap(Comparable<?>[] values, int setValues) {
            HashMap map = new HashMap(setValues);
            for (int i = 0; i < values.length && setValues > 0; ++i) {
                if (values[i] == null) continue;
                map.put(i, values[i]);
                --setValues;
            }
            return map;
        }

        private static boolean isSparse(Comparable<?>[] values, int setValues) {
            return setValues * 100 < values.length;
        }
    }
}

