/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Collections;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitAnalyzer
extends Analyzer {
    private static Logger log = LoggerFactory.getLogger(JackrabbitAnalyzer.class);
    private static final Analyzer DEFAULT_ANALYZER = new StandardAnalyzer(Version.LUCENE_24, Collections.emptySet());
    private Analyzer defaultAnalyzer = DEFAULT_ANALYZER;
    private IndexingConfiguration indexingConfig;

    static Analyzer getAnalyzerInstance(String className) {
        Constructor<?>[] constructors;
        Class<?> analyzerClass;
        try {
            analyzerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.warn(className + " could not be found", (Throwable)e);
            return DEFAULT_ANALYZER;
        }
        if (!Analyzer.class.isAssignableFrom(analyzerClass)) {
            log.warn(className + " is not a Lucene Analyzer");
            return DEFAULT_ANALYZER;
        }
        if (JackrabbitAnalyzer.class.isAssignableFrom(analyzerClass)) {
            log.warn(className + " can not be used as a JackrabbitAnalyzer component");
            return DEFAULT_ANALYZER;
        }
        Exception cause = null;
        for (Constructor<?> constructor : constructors = analyzerClass.getConstructors()) {
            Class<?>[] types = constructor.getParameterTypes();
            if (types.length != 1 || types[0] != Version.class) continue;
            try {
                return (Analyzer)constructor.newInstance(Version.LUCENE_24);
            }
            catch (Exception e) {
                cause = e;
            }
        }
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length != 0) continue;
            try {
                return (Analyzer)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                cause = e;
            }
        }
        log.warn(className + " could not be instantiated", (Throwable)cause);
        return DEFAULT_ANALYZER;
    }

    protected void setIndexingConfig(IndexingConfiguration indexingConfig) {
        this.indexingConfig = indexingConfig;
    }

    protected void setDefaultAnalyzer(Analyzer analyzer) {
        this.defaultAnalyzer = analyzer;
    }

    String getDefaultAnalyzerClass() {
        return this.defaultAnalyzer.getClass().getName();
    }

    void setDefaultAnalyzerClass(String className) {
        this.setDefaultAnalyzer(JackrabbitAnalyzer.getAnalyzerInstance(className));
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer propertyAnalyzer;
        if (this.indexingConfig != null && (propertyAnalyzer = this.indexingConfig.getPropertyAnalyzer(fieldName)) != null) {
            return propertyAnalyzer.tokenStream(fieldName, reader);
        }
        return this.defaultAnalyzer.tokenStream(fieldName, reader);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Analyzer propertyAnalyzer;
        if (this.indexingConfig != null && (propertyAnalyzer = this.indexingConfig.getPropertyAnalyzer(fieldName)) != null) {
            return propertyAnalyzer.reusableTokenStream(fieldName, reader);
        }
        return this.defaultAnalyzer.reusableTokenStream(fieldName, reader);
    }
}

